% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxGeometry.R
\name{radii}
\alias{radii}
\title{The radii of points from one class with respect to points from the other class}
\usage{
radii(x, y)
}
\arguments{
\item{x}{A set of \eqn{d}-dimensional points for which the radii are computed. Radius of an \code{x} point equals to the
distance to the closest \code{y} point.}

\item{y}{A set of \eqn{d}-dimensional points representing the reference points for the balls. That is, radius
of an \code{x} point is defined as the minimum distance to the \code{y} points.}
}
\value{
A \code{list} with three elements
\item{rad}{A \code{vector} whose entries are the radius values for the \code{x} points. Radius of an \code{x} point equals to
the distance to the closest \code{y} point}
\item{index.of.clYp}{A \code{vector} of indices of the closest \code{y} points to the \code{x} points. The \eqn{i}-th entry in this
\code{vector} is the index of the closest \code{y} point to \eqn{i}-th \code{x} point.}
\item{closest.Yp}{A \code{vector} of the closest \code{y} points to the \code{x} points. The \eqn{i}-th entry in this
\code{vector} or \eqn{i}-th row in the matrix is the closest \code{y} point to \eqn{i}-th \code{x} point.}
}
\description{
Returns the radii of the balls centered at \code{x} points where radius of an \code{x} point equals to the minimum distance
to \code{y} points (i.e., distance to the closest \code{y} point). That is, for each \code{x} point \eqn{radius= \min_{y \in Y}(d(x,y))}.
\code{x} and \code{y} points must be of the same dimension.
}
\examples{
\dontrun{
nx<-10
ny<-5
X<-cbind(runif(nx),runif(nx))
Y<-cbind(runif(ny),runif(ny))
Rad<-radii(X,Y)
Rad
rd<-Rad$rad

Xlim<-range(X[,1]-rd,X[,1]+rd,Y[,1])
Ylim<-range(X[,2]-rd,X[,2]+rd,Y[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(rbind(Y),asp=1,pch=16,col=2,xlab="",ylab="",
main="Circles Centered at Class X Points with \n Radius Equal to the Distance to Closest Y Point",
axes=TRUE, xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
points(rbind(X))
interp::circles(X[,1],X[,2],Rad$rad,lty=1,lwd=1,col=4)

#For 1D data
nx<-10
ny<-5
Xm<-as.matrix(X)
Ym<-as.matrix(Y)
radii(Xm,Ym)  #this works as Xm and Ym are treated as 1D data sets
#but will give error if radii(X,Y) is used
#as X and Y are treated as vectors (i.e., points)

#For 3D data
nx<-10
ny<-5
X<-cbind(runif(nx),runif(nx),runif(nx))
Y<-cbind(runif(ny),runif(ny),runif(ny))
radii(X,Y)
}

}
\seealso{
\code{\link{radius}}
}
\author{
Elvan Ceyhan
}
