% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArcSliceFunctions.R
\name{IarcASset2pnt.tri}
\alias{IarcASset2pnt.tri}
\title{The indicator for the presence of an arc from a point in set \code{S} to the point \code{p} for
Arc Slice Proximity Catch Digraphs (AS-PCDs) - one triangle case}
\usage{
IarcASset2pnt.tri(S, p, tri, M = "CC")
}
\arguments{
\item{S}{A set of 2D points whose AS proximity regions are considered.}

\item{p}{A 2D point. The function determines whether \code{p} is inside the union of AS proximity
regions of points in \code{S} or not.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{M}{The center of the triangle. \code{"CC"} stands for circumcenter of the triangle \code{tri} or a 2D point in Cartesian coordinates or
a 3D point in barycentric coordinates which serves as a center in the interior of \code{tri};
default is \code{M="CC"} i.e., the circumcenter of \code{tri}.}
}
\value{
\eqn{I(pt \in \cup_{x in S}N_{AS}(x,r))}, that is, returns 1 if \code{p} is in \code{S} or inside \eqn{N_{AS}(x)} for at least
one \eqn{x} in \code{S}, returns 0 otherwise, where AS proximity region is constructed in \code{tri}
}
\description{
Returns I(\eqn{pt \in N_{AS}(x)} for some \eqn{x \in S}), that is, returns 1 if \eqn{p} is in \eqn{\cup_{x \in S}N_{AS}(x)},
returns 0 otherwise, where \eqn{N_{AS}(x)} is the AS proximity region for point \eqn{x}.

AS proximity regions are constructed with respect to the triangle, \code{tri}\eqn{=T(A,B,C)=}\code{(rv=1,rv=2,rv=3)},
and vertices of \code{tri} are also labeled as 1,2, and 3, respectively.

Vertex regions are based on the center \code{M="CC"} for circumcenter of \code{tri};
or \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the
interior of the triangle \code{tri}; default is \code{M="CC"} i.e., circumcenter of \code{tri}.

If \code{p} is not in \code{S} and either \code{p} or all points in \code{S} are outside \code{tri}, it returns 0,
but if \code{p} is in \code{S}, then it always returns 1 (i.e., loops are allowed).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10

set.seed(1)
Xp<-runif.tri(n,Tr)$gen.points

S<-rbind(Xp[1,],Xp[2,])  #try also S<-c(1.5,1)

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.2)

IarcASset2pnt.tri(S,Xp[3,],Tr,M)

S<-rbind(Xp[1,],Xp[2,],Xp[3,],Xp[5,])
IarcASset2pnt.tri(S,Xp[3,],Tr,M)

IarcASset2pnt.tri(S,Xp[6,],Tr,M)

S<-rbind(c(.1,.1),c(.3,.4),c(.5,.3))
IarcASset2pnt.tri(S,Xp[3,],Tr,M)

IarcASset2pnt.tri(c(.2,.5),Xp[2,],Tr,M)
IarcASset2pnt.tri(Xp,c(.2,.5),Tr,M)
IarcASset2pnt.tri(Xp,Xp[2,],Tr,M)
IarcASset2pnt.tri(c(.2,.5),c(.2,.5),Tr,M)
IarcASset2pnt.tri(Xp[5,],Xp[2,],Tr,M)

S<-rbind(Xp[1,],Xp[2,],Xp[3,],Xp[5,],c(.2,.5))
IarcASset2pnt.tri(S,Xp[3,],Tr,M)

P<-c(.4,.2)
S<-Xp[c(1,3,4),]
IarcASset2pnt.tri(Xp,P,Tr,M)
IarcASset2pnt.tri(S,P,Tr,M)

IarcASset2pnt.tri(rbind(S,S),P,Tr,M)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IarcAStri}}, \code{\link{IarcASset2pnt.tri}}, and \code{\link{IarcCSset2pnt.tri}}
}
\author{
Elvan Ceyhan
}
