% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge3D.R
\name{IarcPEstd.tetra}
\alias{IarcPEstd.tetra}
\title{The indicator for the presence of an arc from a point to another for Proportional Edge Proximity Catch
Digraphs (PE-PCDs) - standard regular tetrahedron case}
\usage{
IarcPEstd.tetra(p1, p2, r, rv = NULL)
}
\arguments{
\item{p1}{A 3D point whose PE proximity region is constructed.}

\item{p2}{A 3D point. The function determines whether \code{p2} is inside the PE proximity region of
\code{p1} or not.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{rv}{Index of the vertex region containing the point, either \code{1,2,3,4} (default is \code{NULL}).}
}
\value{
\eqn{I(}\code{p2} is in \eqn{N_{PE}(p1,r))} for points \code{p1} and \code{p2}, that is, returns 1 if \code{p2} is in \eqn{N_{PE}(p1,r)},
returns 0 otherwise
}
\description{
Returns \eqn{I(}\code{p2} is in \eqn{N_{PE}(p1,r))} for points \code{p1} and \code{p2}, that is, returns 1 if \code{p2} is in \eqn{N_{PE}(p1,r)},
returns 0 otherwise, where \eqn{N_{PE}(x,r)} is the PE proximity region for point \eqn{x} with expansion parameter \eqn{r \ge 1}.

PE proximity region is defined with respect to the standard regular tetrahedron
\eqn{T_h=T(v=1,v=2,v=3,v=4)=T((0,0,0),(1,0,0),(1/2,\sqrt{3}/2,0),(1/2,\sqrt{3}/6,\sqrt{6}/3))} and vertex regions
are based on the circumcenter (which is equivalent to the center of mass for standard regular tetrahedron)
of \eqn{T_h}. \code{rv} is the index of the vertex region \code{p1} resides, with default=\code{NULL}.

If \code{p1} and \code{p2} are distinct and either of them are outside \eqn{T_h}, it returns 0,
but if they are identical, then it returns 1 regardless of their locations (i.e., it allows loops).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(0,0,0); B<-c(1,0,0); C<-c(1/2,sqrt(3)/2,0); D<-c(1/2,sqrt(3)/6,sqrt(6)/3)
tetra<-rbind(A,B,C,D)

n<-3  #try also n<-20
Xp<-runif.std.tetra(n)$g
r<-1.5
IarcPEstd.tetra(Xp[1,],Xp[3,],r)
IarcPEstd.tetra(c(.4,.4,.4),c(.5,.5,.5),r)

#or try
RV<-rel.vert.tetraCC(Xp[1,],tetra)$rv
IarcPEstd.tetra(Xp[1,],Xp[3,],r,rv=RV)

P1<-c(.1,.1,.1)
P2<-c(.5,.5,.5)
IarcPEstd.tetra(P1,P2,r)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IarcPEtetra}}, \code{\link{IarcPEtri}} and \code{\link{IarcPEint}}
}
\author{
Elvan Ceyhan
}
