% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge1D.R
\name{PEdom.num1D}
\alias{PEdom.num1D}
\title{The domination number of Proportional Edge Proximity Catch Digraph (PE-PCD) for 1D data}
\usage{
PEdom.num1D(Xp, Yp, r, c = 0.5)
}
\arguments{
\item{Xp}{A set of 1D points which constitute the vertices of the PE-PCD.}

\item{Yp}{A set of 1D points which constitute the end points of the intervals which
partition the real line.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \code{int} (default \code{c=.5}).}
}
\value{
A \code{list} with three elements
\item{dom.num}{Domination number of PE-PCD with vertex set \code{Xp} and expansion parameter \eqn{r \ge 1} and
centrality parameter \eqn{c \in (0,1)}.}
\item{mds}{A minimum dominating set of the PE-PCD.}
\item{ind.mds}{The data indices of the minimum dominating set of the PE-PCD whose vertices are \code{Xp} points.}
\item{int.dom.nums}{Domination numbers of the PE-PCD components for the partition intervals.}
}
\description{
Returns the domination number, a minimum dominating set of PE-PCD whose vertices are the 1D data set \code{Xp},
and the domination numbers for partition intervals based on \code{Yp}.

\code{Yp} determines the end points of the intervals (i.e., partition the real line via intervalization).
It also includes the domination numbers in the end intervals, with interval label 1 for the left end interval
and $|Yp|+1$ for the right end interval.

PE proximity region is constructed with expansion parameter \eqn{r \ge 1} and centrality parameter \eqn{c \in (0,1)}.
}
\examples{
\dontrun{
a<-0; b<-10
c<-.4
r<-2

#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-15; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-runif(nx,a,b)
Yp<-runif(ny,a,b)

PEdom.num1D(Xp,Yp,r,c)

PEdom.num1D(Xp,Yp,r,c=.25)
PEdom.num1D(Xp,Yp,r=1.25,c)
}

}
\seealso{
\code{\link{PEdom.num.nondeg}}
}
\author{
Elvan Ceyhan
}
