% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim2D.R
\name{funsCSt1EdgeRegs}
\alias{funsCSt1EdgeRegs}
\alias{IarcCSt1.std.triRAB}
\alias{IarcCSt1.std.triRBC}
\alias{IarcCSt1.std.triRAC}
\title{Each function is for the presence of an arc from a point in one of the edge regions
to another for Central Similarity Proximity Catch Digraphs (CS-PCDs) -
standard equilateral triangle case with \eqn{t=1}}
\usage{
IarcCSt1.std.triRAB(p1, p2)

IarcCSt1.std.triRBC(p1, p2)

IarcCSt1.std.triRAC(p1, p2)
}
\arguments{
\item{p1}{A 2D point whose CS proximity region is constructed.}

\item{p2}{A 2D point. The function determines whether \code{p2} is inside the CS proximity region of
\code{p1} or not.}
}
\value{
Each function returns \eqn{I(}\code{p2} is in \eqn{N_{CS}(p1,t=1))} for \code{p1}, that is,
returns 1 if \code{p2} is in \eqn{N_{CS}(p1,t=1)}, returns 0 otherwise
}
\description{
Three indicator functions: \code{IarcCSt1.std.triRAB}, \code{IarcCSt1.std.triRBC} and \code{IarcCSt1.std.triRAC}.

The function \code{IarcCSt1.std.triRAB} returns \eqn{I(}\code{p2} is in \eqn{N_{CS}(p1,t=1)} for \code{p1} in \eqn{RAB}
(edge region for edge \eqn{AB}, i.e., edge 3) in the standard equilateral triangle \eqn{T_e=T(A,B,C)=T((0,0),(1,0),(1/2,\sqrt{3}/2))};

\code{IarcCSt1.std.triRBC} returns \eqn{I(}\code{p2} is in \eqn{N_{CS}(p1,t=1)} for \code{p1} in \eqn{RBC} (edge region for edge \eqn{BC}, i.e., edge 1) in \eqn{T_e};
and

\code{IarcCSt1.std.triRAC} returns \eqn{I(}\code{p2} is in \eqn{N_{CS}(p1,t=1)} for \code{p1} in \eqn{RAC} (edge region for edge \eqn{AC}, i.e., edge 2) in \eqn{T_e}.

That is, each function returns 1 if \code{p2} is in \eqn{N_{CS}(p1,t=1)}, returns 0 otherwise, where \eqn{N_{CS}(x,t)} is the
CS proximity region for point \eqn{x} with expansion parameter \eqn{t=1}.
}
\examples{
\dontrun{
#Examples for IarcCSt1.std.triRAB
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
CM<-(A+B+C)/3
T3<-rbind(A,B,CM);

set.seed(1)
Xp<-runif.std.tri(10)$gen.points

IarcCSt1.std.triRAB(Xp[1,],Xp[2,])

IarcCSt1.std.triRAB(c(.2,.5),Xp[2,])
}

\dontrun{
#Examples for IarcCSt1.std.triRBC
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
CM<-(A+B+C)/3
T1<-rbind(B,C,CM);

set.seed(1)
Xp<-runif.std.tri(3)$gen.points

IarcCSt1.std.triRBC(Xp[1,],Xp[2,])

IarcCSt1.std.triRBC(c(.2,.5),Xp[2,])
}

\dontrun{
#Examples for IarcCSt1.std.triRAC
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
CM<-(A+B+C)/3
T2<-rbind(A,C,CM);

set.seed(1)
Xp<-runif.std.tri(3)$gen.points

IarcCSt1.std.triRAC(Xp[1,],Xp[2,])
IarcCSt1.std.triRAC(c(1,2),Xp[2,])
}

}
\seealso{
\code{\link{IarcCSstd.triRAB}}, \code{\link{IarcCSstd.triRBC}} and \code{\link{IarcCSstd.triRAC}}
}
\author{
Elvan Ceyhan
}
