% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArcSliceFunctions.R
\name{plotASarcs.tri}
\alias{plotASarcs.tri}
\title{The plot of the arcs of Arc Slice Proximity Catch Digraph (AS-PCD) for a 2D data set - one triangle case}
\usage{
plotASarcs.tri(
  Xp,
  tri,
  M = "CC",
  asp = NA,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  vert.reg = FALSE,
  ...
)
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the AS-PCD.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{M}{The center of the triangle. \code{"CC"} stands for circumcenter of the triangle \code{tri} or a 2D point in Cartesian coordinates or a 3D point in
barycentric coordinates which serves as a center in the interior of the triangle \eqn{T_b};
default is \code{M="CC"} i.e., the circumcenter of \code{tri}.}

\item{asp}{A \code{numeric} value, giving the aspect ratio for \eqn{y} axis to \eqn{x}-axis \eqn{y/x} (default is \code{NA}),
see the official help page for \code{asp} by typing "\code{? asp}".}

\item{main}{An overall title for the plot (default=\code{NULL}).}

\item{xlab, ylab}{Titles for the \eqn{x} and \eqn{y} axes, respectively (default=\code{NULL} for both).}

\item{xlim, ylim}{Two \code{numeric} vectors of length 2, giving the \eqn{x}- and \eqn{y}-coordinate ranges
(default=\code{NULL} for both).}

\item{vert.reg}{A logical argument to add vertex regions to the plot, default is \code{vert.reg=FALSE}.}

\item{\dots}{Additional \code{plot} parameters.}
}
\value{
A plot of the arcs of the AS-PCD for a 2D data set \code{Xp} where AS proximity regions
are defined with respect to the triangle \code{tri}; also plots the triangle \code{tri}
}
\description{
Plots the arcs of AS-PCD whose vertices are the data points, \code{Xp} and the triangle \code{tri}. AS proximity regions
are constructed with respect to the triangle \code{tri}, i.e., only for \code{Xp} points inside the triangle \code{tri}.

Vertex regions are based on the center \code{M="CC"} for
circumcenter of \code{tri}; or \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric
coordinates in the interior of the triangle \code{tri}; default is \code{M="CC"} the circumcenter of \code{tri}.
When the center is the circumcenter, \code{CC}, the vertex regions are constructed based on the
orthogonal projections to the edges, while with any interior center \code{M}, the vertex regions are constructed using the extensions
of the lines combining vertices with \code{M}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10

set.seed(1)
Xp<-runif.tri(n,Tr)$g  #try also Xp<-cbind(runif(n,1,2),runif(n,0,2))

M<-as.numeric(runif.tri(1,Tr)$g)  #try also  #M<-c(1.6,1.2)

plotASarcs.tri(Xp,Tr,M,main="Arcs of AS-PCD",xlab="",ylab="")

plotASarcs.tri(Xp,Tr,M,main="Arcs of AS-PCD",xlab="",ylab="",vert.reg = TRUE)

# or try the default center
#plotASarcs.tri(Xp,Tr,asp=1,main="arcs of AS-PCD",xlab="",ylab="",vert.reg = TRUE);
#M = (arcsAStri(Xp,Tr)$param)$c #the part "M = as.numeric(arcsAStri(Xp,Tr)$param)" is optional,
#for the below annotation of the plot

#can add vertex labels and text to the figure (with vertex regions)
#but first we need to determine whether the center used for vertex regions is CC or not
#see the description for more detail.
CC<-circumcenter.tri(Tr)

if (isTRUE(all.equal(M,CC)) || identical(M,"CC"))
{cent<-CC
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
Ds<-rbind(D1,D2,D3)
cent.name<-"CC"
} else
{cent<-M
cent.name<-"M"
Ds<-prj.cent2edges(Tr,M)
}

#now we add the vertex names and annotation
txt<-rbind(Tr,cent,Ds)
xc<-txt[,1]+c(-.02,.02,.02,.01,.05,-0.03,-.01)
yc<-txt[,2]+c(.02,.02,.02,.07,.02,.05,-.06)
txt.str<-c("A","B","C",cent.name,"D1","D2","D3")
text(xc,yc,txt.str)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotASarcs}}, \code{\link{plotPEarcs.tri}}, \code{\link{plotPEarcs}},
\code{\link{plotCSarcs.tri}}, and \code{\link{plotCSarcs}}
}
\author{
Elvan Ceyhan
}
