% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge1D.R
\name{plotPEarcs1D}
\alias{plotPEarcs1D}
\title{The plot of the arcs of Proportional Edge Proximity Catch Digraphs (PE-PCDs) for 1D data
(vertices jittered along \eqn{y}-coordinate) - multiple interval case}
\usage{
plotPEarcs1D(
  Xp,
  Yp,
  r,
  c = 0.5,
  Jit = 0.1,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  xlim = NULL,
  ylim = NULL,
  centers = FALSE,
  ...
)
}
\arguments{
\item{Xp}{A \code{vector} of 1D points constituting the vertices of the PE-PCD.}

\item{Yp}{A \code{vector} of 1D points constituting the end points of the intervals.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside middle intervals
with the default \code{c=.5}.
For the interval, \eqn{(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}

\item{Jit}{A positive real number that determines the amount of jitter along the \eqn{y}-axis, default=\code{0.1} and
\code{Xp} points are jittered according to \eqn{U(-Jit,Jit)} distribution along the \eqn{y}-axis
where \code{Jit} equals to the range of the union of \code{Xp} and \code{Yp} points multiplied by \code{Jit}).}

\item{main}{An overall title for the plot (default=\code{NULL}).}

\item{xlab, ylab}{Titles of the \eqn{x} and \eqn{y} axes in the plot (default=\code{NULL} for both).}

\item{xlim, ylim}{Two \code{numeric} vectors of length 2, giving the \eqn{x}- and \eqn{y}-coordinate ranges
(default=\code{NULL} for both).}

\item{centers}{A logical argument, if \code{TRUE}, plot includes the centers of the intervals
as vertical lines in the plot, else centers of the intervals are not plotted.}

\item{\dots}{Additional \code{plot} parameters.}
}
\value{
A plot of the arcs of PE-PCD whose vertices are the 1D data set \code{Xp} in which vertices are jittered
along \eqn{y}-axis for better visualization.
}
\description{
Plots the arcs of PE-PCD whose vertices are the 1D points, \code{Xp}. PE proximity regions are constructed with
expansion parameter \eqn{r \ge 1} and centrality parameter \eqn{c \in (0,1)} and the intervals are based on \code{Yp} points (i.e.
the intervalization is based on \code{Yp} points). That is, data set \code{Xp}
constitutes the vertices of the digraph and \code{Yp} determines the end points of the intervals.

For better visualization, a uniform jitter from \eqn{U(-Jit,Jit)} (default for \eqn{Jit=.1}) is added to
the \eqn{y}-direction where \code{Jit} equals to the range of \code{Xp} and \code{Yp} multiplied by \code{Jit} with default for \eqn{Jit=.1}).
\code{centers} is a logical argument, if \code{TRUE}, plot includes the centers of the intervals
as vertical lines in the plot, else centers of the intervals are not plotted.

See also (\insertCite{ceyhan:metrika-2012;textual}{pcds}).
}
\examples{
\dontrun{
r<-2
c<-.4
a<-0; b<-10; int<-c(a,b)

#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
xf<-(int[2]-int[1])*.1

Xp<-runif(nx,a-xf,b+xf)
Yp<-runif(ny,a,b)

Xlim=range(Xp,Yp)
Ylim=.1*c(-1,1)

jit<-.1

set.seed(1)
plotPEarcs1D(Xp,Yp,r=1.5,c=.3,jit,xlab="",ylab="",centers=TRUE)
set.seed(1)
plotPEarcs1D(Xp,Yp,r=2,c=.3,jit,xlab="",ylab="",centers=TRUE)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotPEarcs.int}} and \code{\link{plotCSarcs1D}}
}
\author{
Elvan Ceyhan
}
