% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simCE.r
\name{simCE}
\alias{simCE}
\title{CE Simulator}
\usage{
simCE(data, vol = 1, sd.vol = 0, intercept = -7.7662, slope = 0.859,
  sigma = 0.5798, t.intercept = 10.82719, t.slope = 0.9047,
  t.sigma = 0.5951, debug = FALSE)
}
\arguments{
\item{data}{data.frame with simulated data. Preferably output from  \code{\link{simPCR}}.
Required columns are 'PCR.Vol' and 'PCR.Amplicon'.}

\item{vol}{numeric for the aliquot PCR product for CE analysis.}

\item{sd.vol}{numeric for the standard deviation of \code{vol}.}

\item{intercept}{numeric for the intercept of the linear model to scale molecules -> rfu.}

\item{slope}{numeric for the slope of the linear model to scale molecules -> rfu.}

\item{sigma}{numeric for the residual standard error of the linear model to scale molecules -> rfu. NB! NOT USED!}

\item{t.intercept}{numeric for the intercept of the linear model to calculate detection threshold (molecules).}

\item{t.slope}{numeric for the slope of the linear model  to calculate detection threshold (molecules). NB! NOT USED!}

\item{t.sigma}{numeric for the residual standard error of the linear model  to calculate detection threshold (molecules).}

\item{debug}{logical for printing debug information.}
}
\value{
data.frame with simulation results in columns 'CE.xxx'.
}
\description{
Simulates the capillary elechtrophoresis (CE) process.
}
\details{
Simulates the forensic capillary electrophoresis analysis of
PCR product.
}
\examples{
# Create a data frame with a DNA profile.
markers = rep(c("D3S1358","TH01","FGA"), each=2)
alleles = c(15,18,6,10,25,25)
df <- data.frame(Marker=markers, Allele=alleles)

# Simulate profile.
res <- simProfile(data=df, sim=5, name="Test")

# Simulate sample
res <- simSample(data=res, cells=58, sd.cells=0)

# Simulate extraction.
res <- simExtraction(data=res, vol.ex=1, sd.vol=0, prob.ex=1, sd.prob=0)

# Simulate PCR.
res <- simPCR(data=res, kit=NULL, pcr.cyc=30, vol.aliq=1, sd.vol.aliq=0, vol.pcr=25, sd.vol.pcr=0)

# Simulate CE.
res <- simCE(data=res, vol=1, sd.vol=0, intercept=-10.48, slope=0.86, sigma=0.58)
print(res)
}
\seealso{
\code{\link{simPCR}}
}
