% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/N-cycle.R
\name{plot_N_cycle}
\alias{plot_N_cycle}
\title{Plot the N-cycling pathway and genes}
\usage{
plot_N_cycle(
  my_N_genes = NULL,
  just_diff = FALSE,
  path_col = NULL,
  type_col = c(up = "red", down = "blue", none = NA),
  fill_alpha = 0.5,
  arrow_size = 0.1,
  line_width = 1,
  title = "Nitrogen cycling",
  legend.position = c(0.85, 0.15)
)
}
\arguments{
\item{my_N_genes}{dataframe, "Gene_families","type" should in colnames of my_N_genes}

\item{just_diff}{logical, just plot the different genes?}

\item{path_col}{colors of pathways}

\item{type_col}{colors of types}

\item{fill_alpha}{alpha, default 0.5}

\item{arrow_size}{arrow_size, default 0.1}

\item{line_width}{line_width, default 1}

\item{title}{title, default "Nitrogen cycling"}

\item{legend.position}{default c(0.85,0.15)}
}
\value{
ggplot
}
\description{
Plot the N-cycling pathway and genes
}
\examples{
N_data <- load_N_data()
my_N_genes <- data.frame(
    `Gene_families` = sample(N_data$N_genes$Gene_families, 10, replace = FALSE),
    change = rnorm(10), check.names = FALSE
)
my_N_genes <- dplyr::mutate(my_N_genes,
    type = ifelse(change > 0, "up", ifelse(change < 0, "down", "none"))
)
plot_N_cycle(my_N_genes, just_diff = FALSE, fill_alpha = 0.2)
# ggsave(filename = "test.pdf", width = 14, height = 10)
}
