% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{df2distance}
\alias{df2distance}
\title{Convert Three-column Data to Distance Matrix}
\usage{
df2distance(data)
}
\arguments{
\item{data}{A data frame containing three columns: from, to, count.}
}
\value{
A distance matrix where rows and columns are all unique names from 'from' and 'to' columns.
}
\description{
This function converts a data frame with three columns (from, to, count) into a distance matrix.
The rows and columns of the matrix are all unique names from the 'from' and 'to' columns,
and the matrix values are filled with counts.
}
\examples{
data <- data.frame(
  from = c("A", "A", "B", "D"),
  to = c("B", "C", "A", "B"),
  count = c(1, 2, 3, 4)
)
df2distance(data)
}
