% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_tools.R
\name{download_ncbi_genome_file}
\alias{download_ncbi_genome_file}
\title{Download genome files from NCBI based on accession number}
\usage{
download_ncbi_genome_file(
  accession,
  out_dir = ".",
  type = "gff",
  file_suffix = NULL,
  timeout = 300
)
}
\arguments{
\item{accession}{A character string representing the NCBI accession number
(e.g., "GCF_001036115.1_ASM103611v1" or "GCF_001036115.1"). The accession can start with
"GCF" or "GCA".}

\item{out_dir}{A character string representing the directory where the
downloaded files will be saved. Defaults to the current working directory (".").}

\item{type}{A character string representing the type of file to download.
Supported types are "all", "gff", "fna". If "all" is specified,
the function will prompt the user to use command line tools to download
the entire directory. Defaults to "gff".}

\item{file_suffix}{A character string representing the specific file suffix to download.
If specified, this will override the \code{type} parameter. Defaults to NULL.}

\item{timeout}{A numeric value representing the maximum time in seconds to wait for the download. Defaults to 300.}
}
\value{
No value
}
\description{
This function downloads specific genomic files from NCBI's FTP server
based on the provided accession number. It supports downloading
different types of files, or the entire directory containing the files.
}
\details{
If the provided \code{accession} does not contain the version suffix (e.g., "GCF_001036115.1"),
the function will query the NCBI FTP server to determine the full accession name.

When \code{type} is set to "all", the function cannot download the entire directory
directly but provides a command line example for the user to download the directory
using tools like \code{wget}.
}
\examples{
\dontrun{
download_ncbi_genome_file("GCF_001036115.1", out_dir = "downloads", type = "gff")
download_ncbi_genome_file("GCF_001036115.1", out_dir = "downloads", file_suffix = "_genomic.fna.gz")
}

}
