% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmSurvPlot.R
\name{brmSurvPlot}
\alias{brmSurvPlot}
\title{Function to visualize brms survival models specified using growthSS.}
\usage{
brmSurvPlot(
  fit,
  form,
  df = NULL,
  groups = NULL,
  timeRange = NULL,
  facetGroups = TRUE
)
}
\arguments{
\item{fit}{A brmsfit object, similar to those fit with \code{\link{growthSS}} outputs.}

\item{form}{A formula similar to that in \code{growthSS} inputs specifying the outcome,
predictor, and grouping structure of the data as \code{outcome ~ predictor|individual/group}.}

\item{df}{An optional dataframe to use in plotting observed growth curves on top of the model.}

\item{groups}{An optional set of groups to keep in the plot.
Defaults to NULL in which case all groups in the model are plotted.}

\item{timeRange}{An optional range of times to use. This can be used to view predictions for
future data if the available data has not reached some point (such as asymptotic size),
although prediction using splines outside of the observed range is not necessarily reliable.}

\item{facetGroups}{logical, should groups be separated in facets? Defaults to TRUE.}
}
\value{
Returns a ggplot showing a brms model's credible
intervals and optionally the individual growth lines.
}
\description{
Models fit using \link{growthSS} inputs by \link{fitGrowth}
(and similar models made through other means)
 can be visualized easily using this function. This will generally be called by \code{growthPlot}.
}
\examples{

\donttest{
  set.seed(123)
  df <- growthSim("exponential",
    n = 20, t = 50,
    params = list("A" = c(1, 1), "B" = c(0.15, 0.1))
  )
  ss1 <- growthSS(
    model = "survival weibull", form = y > 100 ~ time | id / group,
    df = df, start = c(0, 5)
  )
  fit1 <- fitGrowth(ss1, iter = 600, cores = 2, chains = 2, backend = "cmdstanr")
  brmSurvPlot(fit1, form = ss1$pcvrForm, df = ss1$df)

  # note that using the cumulative hazard to calculate survival is likely to underestimate
  # survival in these plots if events do not start immediately.
  ss2 <- growthSS(
    model = "survival binomial", form = y > 100 ~ time | id / group,
    df = df, start = c(-4, 3)
  )
  fit2 <- fitGrowth(ss2, iter = 600, cores = 2, chains = 2, backend = "cmdstanr")
  brmSurvPlot(fit2, form = ss2$pcvrForm, df = ss2$df)
}


}
