% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siteAdjustment.R
\name{siteAdjustment}
\alias{siteAdjustment}
\title{Site adjustment}
\usage{
siteAdjustment(
  phenoData,
  descriptors = c("Diameter at breast height (m)", "Lower crown height (m)",
    "Timber height (m)", "Total height (m)", "Crown radius (m)")
)
}
\arguments{
\item{phenoData}{phenoData tibble containing phenotype data}

\item{descriptors}{columns of phenoData on which to perform site correction}
}
\description{
Perform a site adjustment of selected descriptors.
}
\examples{
library(dplyr)

## Retrieve file paths for example data
files <- list.files(system.file('phenotypeDataCollectionSheets',
  package = 'pdi'),full.names = TRUE)

## Prepare data
d <- map(files,readPhenotypeSheet) \%>\%
  map(preparePhenotypeData) \%>\%
  bind_rows() \%>\%
  siteAdjustment() 
}
