% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form-other.R
\name{form_smooth}
\alias{form_smooth}
\title{Smooth pdqr-function}
\usage{
form_smooth(f, n_sample = 10000, args_new = list())
}
\arguments{
\item{f}{A pdqr-function.}

\item{n_sample}{Number of elements to sample.}

\item{args_new}{List of extra arguments for \link[=new_d]{new_*()} to control
\code{\link[=density]{density()}}.}
}
\value{
A smoothed version of \code{f} with the same \link[=meta_class]{class} and
\link[=meta_type]{type}.
}
\description{
Smooth pdqr-function using random sampling and corresponding
\link[=new-pdqr]{new_*()} function.
}
\details{
General idea of smoothing is to preserve "sampling randomness" as
much as reasonably possible while creating more "smooth" probability mass or
density function.

At first step, sample of size \code{n_sample} is generated from distribution
represented by \code{f}. Then, based on the sample, "continuous" d-function is
created with \code{new_d()} and arguments from \code{args_new} list. To account for
\link[stats:density]{density()}'s default behavior of "stretching range" by
adding small tails, \link[=meta_support]{support} of d-function is forced to be
equal to \code{f}'s support (this is done with \code{\link[=form_resupport]{form_resupport()}} and method
"reflect"). Output represents a "smooth" version of \code{f} as d-function.

Final output is computed by modifying "y" or "prob" column of \code{f}'s \link[=meta_x_tbl]{"x_tbl" metadata} to be proportional to values of "smooth" output at
corresponding points from "x" column. This way output distribution has
exactly the same "x" grid as \code{f} but "more smooth" nature.
}
\examples{
set.seed(101)

# Type "discrete"
bad_dis <- new_d(
  data.frame(x = sort(runif(100)), prob = runif(100)),
  type = "discrete"
)
smoothed_dis <- form_smooth(bad_dis)
plot(bad_dis)
lines(smoothed_dis, col = "blue")

# Type "continuous"
bad_con <- new_d(
  data.frame(x = sort(runif(100)), y = runif(100)),
  type = "continuous"
)
smoothed_con <- form_smooth(bad_con)
plot(bad_con)
lines(smoothed_con, col = "blue")

}
\seealso{
Other form functions: 
\code{\link{form_estimate}()},
\code{\link{form_mix}()},
\code{\link{form_regrid}()},
\code{\link{form_resupport}()},
\code{\link{form_retype}()},
\code{\link{form_tails}()},
\code{\link{form_trans}()}
}
\concept{form functions}
