% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdynmc_NLIV.R
\name{FDLS}
\alias{FDLS}
\title{First Difference Least Squares (FDLS) Estimator of Han and Phillips (2010).}
\usage{
FDLS(dat, varname.i, varname.t, varname.y)
}
\arguments{
\item{dat}{A dataset.}

\item{varname.i}{The name of the cross-section identifier.}

\item{varname.t}{The name of the time-series identifier.}

\item{varname.y}{A character string denoting the name of the dependent variable
in the dataset.}
}
\value{
An object of class `numeric` that contains the coefficient estimate for
   the lag parameter according to the two roots of the quadratic equation.
}
\description{
\code{FDLS} computes closed form estimator for lag parameter of linear
   dynamic panel data model based on first difference least squares (FDLS)
   estimator.
}
\details{
The function estimates a linear dynamic panel data model of the form
   \deqn{y_{i,t} = y_{i,t-1} \rho_1 + a_i + \varepsilon_{i,t}}
   where \eqn{y_{i,t-1}} is the lagged dependent variable, \eqn{\rho_1} is
   the lag parameter, \eqn{a_i} is an unobserved individual specific effect,
   and \eqn{\varepsilon_{i,t}} is an idiosyncratic remainder component. The
   model structure accounts for unobserved individual specific heterogeneity
   and dynamics. Note that more general lag structures and further covariates
   are beyond the scope of the current implementation in \code{pdynmc}.

   More details on the FDLS estimator and its properties are provided
   in \insertCite{HanPhi2010;textual}{pdynmc}.
}
\examples{
## Load data
data(cigDemand, package = "pdynmc")
dat <- cigDemand

## Code example
m1 <- FDLS(dat = dat, varname.i = "state", varname.t = "year", varname.y = "packpc")


}
\references{
\insertAllCited{}
}
\author{
Joachim Schnurbus, Markus Fritsch
}
