% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cow_trade.R
\name{add_cow_trade}
\alias{add_cow_trade}
\title{Add Correlates of War trade data to a dyad-year or state-year data frame}
\usage{
add_cow_trade(data)
}
\arguments{
\item{data}{a dyad-year data frame (either "directed" or "non-directed") or a state-year data frame}
}
\value{
\code{add_cow_trade()} takes a dyad-year data frame or state-year data frame and
adds information about the volume of trade in that given dyad-year or state-year. For the state-year
data, these are minimally the sum of all imports and the sum of all exports. For dyad-year data,
this function returns the value of imports in current million USD in the first country from
the second country (and vice-versa) along with their "smooth" equivalents.
}
\description{
\code{add_cow_trade()} allows you to add Correlates of War alliance
data to a dyad-year data frame
}
\details{
For the dyad-year data, there must be some kind of information loss in order to work within the
limited space available to this package. This package loads a truncated version of the data
from my website. It will also load these data every time you use the function for dyad-year data.
This implies 1) you probably should not use this function unless you earnestly want these data, 2) this
function won't work for you without an active internet connection, and 3) this will be one of the slowest
functions in the entire package.
}
\examples{

\donttest{
# just call `library(tidyverse)` at the top of the your script
library(magrittr)

# assumes an active internet connection
cow_ddy \%>\% add_cow_trade()
}
}
\references{
Barbieri, Katherine, Omar M. G. Keshk, and Brian Pollins. 2009. "TRADING DATA: Evaluating our Assumptions and Coding Rules."
\emph{Conflict Management and Peace Science}. 26(5): 471-491.
}
\author{
Steven V. Miller
}
