% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_dyadyears.R
\name{create_dyadyears}
\alias{create_dyadyears}
\title{Create dyad-years from state system membership data}
\usage{
create_dyadyears(system = "cow", mry = TRUE, directed = TRUE)
}
\arguments{
\item{system}{a character specifying whether the user wants Correlates of War
state-years ("cow") or Gleditsch-Ward ("gw") state-years. Correlates of War is the
default.}

\item{mry}{optional, defaults to TRUE. If TRUE, the function extends the script
beyond the most recent system membership updates to include observation to the
most recently concluded calendar year. For example, the Gleditsch-Ward data extend
to the end of 2017. When \code{mry == TRUE}, the function returns more recent years
(e.g. 2018, 2019) under the assumption that states alive at the end of 2017 are still alive
today. Use with some care.}

\item{directed}{optional, defaults to TRUE. If TRUE, the function returns so-called
"directed" dyad-year data. In directed dyad-year data, France-Germany (220-255) and
Germany-France (255-220) are observationally different. If FALSE, the function returns
non-directed data. In non-directed data, France-Germany and Germany-France in the same year
are the same observation. The standard here is to drop cases where the country code for the
second observation is less than the country code for the first observation.}
}
\value{
\code{create_dyadyears()} takes state system membership data provided
by either Correlates of War or Gleditsch-Ward and returns a dyad-year data frame.
}
\description{
\code{create_dyadyears()} allows you to dyad-year data from
either the Correlates of War (\code{CoW}) state system membership data or the
Gleditsch-Ward (\code{gw}) system membership data. The function leans on internal
data provided in the package.
}
\examples{
\donttest{
# CoW is default, will include years beyond 2016 (most recent CoW update)
create_dyadyears()

# Gleditsch-Ward, include most recent years
create_dyadyears(system="gw")

# Gleditsch-Ward, don't include most recent years
create_dyadyears(system="gw", mry=FALSE)

# Gleditsch-Ward, don't include most recent years, directed = FALSE
create_dyadyears(system="gw", mry=FALSE, directed = FALSE)
}

}
\references{
Miller, Steven V. 2019. ``Create Country-Year and (Non)-Directed Dyad-Year Data With Just a Few Lines in R''
\url{http://svmiller.com/blog/2019/01/create-country-year-dyad-year-from-country-data/}
}
\author{
Steven V. Miller
}
