% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cow_sdp_gdp}
\alias{cow_sdp_gdp}
\title{(Surplus and Gross) Domestic Product for Correlates of War States}
\format{
A data frame with 27753 observations on the following five variables.
\describe{
\item{\code{ccode}}{a numeric vector for the Correlates of War state code}
\item{\code{year}}{a numeric vector for the year}
\item{\code{wbgdp2011est}}{a numeric vector for the estimated natural log of GDP in 2011 USD (log-transformed)}
\item{\code{wbpopest}}{a numeric vector for the estimated population size (log-transformed)}
\item{\code{sdpest}}{a numeric vector for the estimated surplus domestic product (log-transformed)}
\item{\code{wbgdppc2011est}}{a numeric vector for the estimated GDP per capita (log-transformed)}
}
}
\usage{
cow_sdp_gdp
}
\description{
These are state-year level data for surplus and gross domestic product for Correlates of War state system members. Data also
include population estimates for per capita standardization.
}
\details{
These were extracted from the actual replication files from \emph{International Studies Quarterly}. Because these
data are ultimately being simulated, a user can expect some slight differences between the Correlates of War version of these data
(which Anders et al. published) and the Gleditsch-Ward version of these data (which appear to be the one the authors will more
vigorously support going forward).

Space considerations compel me to round these data to three decimal points.  These "economic" data are routinely
the biggest in the package, and it's because of the decimal points. The justification for this is these data are estimated/simulated
anyways and the information loss is at the 1/1000th decimal point. This procedure basically cuts the size of the data to be less than
25\% of its original size. The original simulations are available for remote download if you'd like. Type \code{?download_extdata()} for
more information.
}
\references{
Anders, Therese, Christopher J. Fariss, and Jonathan N. Markowitz. 2020. "Bread Before Guns or Butter: Introducing Surplus Domestic Product (SDP)"
\emph{International Studies Quarterly} 64(2): 392--405.
}
\keyword{datasets}
