% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakPantheR_loadAnnotationParamsCSV.R
\name{peakPantheR_loadAnnotationParamsCSV}
\alias{peakPantheR_loadAnnotationParamsCSV}
\title{Load fit parameters from CSV}
\usage{
peakPantheR_loadAnnotationParamsCSV(CSVParamPath, verbose = TRUE)
}
\arguments{
\item{CSVParamPath}{(str) Path to a CSV file of fit parameters as saved by \code{outputAnnotationDiagnostic}}

\item{verbose}{(bool) If TRUE message progress}
}
\value{
(peakPantheRAnnotation) Object initialised with ROI, uROI and FIR read from the CSV file
}
\description{
Initialise a new \code{peakPantheRAnnotation} object after loading ROI, uROI and FIR parameters from CSV. \code{spectraPaths}, \code{spectraMetadata} or \code{cpdMetadata} are not initialised and will need to be filled before annotation. \code{useUROI} and \code{useFIR} are set to \code{FALSE} and will need to be set accordingly. \code{uROIExist} is established depending on the uROI columns present in the CSV and will be set to \code{TRUE} only if no \code{NA} are present
}
