% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cppBP}
\alias{cppBP}
\title{Pediatric Blood Pressure}
\usage{
cppBP(
  qp_sbp,
  qp_dbp,
  age,
  male,
  height,
  height_percentile,
  default_height_percentile,
  source,
  type
)
}
\arguments{
\item{qp_sbp}{the quantile(s) or probability(s) for systolic blood pressure}

\item{qp_dbp}{the quantile(s) or probability(s) for diastolic blood pressure}

\item{age}{numeric vector, in months}

\item{male}{integer vector; 0 = female, 1 = male}

\item{height}{numeric vector of stature}

\item{height_percentile}{numeric vector for height percentiles, expected
values between 0 and 1.}

\item{default_height_percentile}{default height percentile to use if \code{height} is missing}

\item{source}{the method, or data set, to use as the reference.}

\item{type}{quantile or distribution to return}
}
\value{
A list:

[[1]] systolic blood pressure quantiles or probability (defined by the input value of \code{type}).
[[2]] diastolic blood pressure quantiles or probability (defined by the input value of \code{type}).

\code{attr(, "bp_params")} is a \code{data.frame} with the values for the
look up table(s) needed to inform the sbp and dbp values.
}
\description{
Pediatric Blood Pressure quantile and probability
(distribution function) values
}
\details{
\code{height} is used preferentially over \code{height_percentile} over
\code{default_height_percentile}.

\code{source} can be one of \code{"gemelli1990"}, \code{"lo2013"},
\code{"nhlbi"}, \code{"flynn2017"}, or \code{"martin2022"}.
}
