% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md_stock_fs.R
\name{md_stock_financials}
\alias{md_stock_financials}
\title{query financial statements}
\usage{
md_stock_financials(symbol, type = NULL, print_step = 1L)
}
\arguments{
\item{symbol}{symbol of stock shares.}

\item{type}{the type of financial statements.}

\item{print_step}{A non-negative integer. Print symbol name by each print_step iteration. Default is 1L.}
}
\description{
\code{md_stock_financials} provides an interface to query financial statements and indicators of listed companies in SSE and SZSE.
}
\examples{
\dontrun{
# interactively specify type of financial table 
dat1 = md_stock_financials("000001")

# manually specify type of financial table
# type = "fr0"
dat2 = md_stock_financials("000001", type="fs0")
# or type = "fr0_summary"
dat3 = md_stock_financials("000001", type="fs0_summary")

# multiple symbols and statements
dat4 = md_stock_financials(c("000001", "600000"), type = "fi")

# dupont analysis indicators
fs_idx = md_stock_financials(c('000001', '^000001'), type = 'dupont')

}

}
