% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergePed.R
\name{mergePed}
\alias{mergePed}
\title{Merge two pedigrees}
\usage{
mergePed(x, y, ...)
}
\arguments{
\item{x, y}{\code{\link[=ped]{ped()}} objects}

\item{...}{further arguments passed along to \code{\link[=ped]{ped()}}, e.g.
\code{famid}, \code{validate} and \code{reorder}.}
}
\value{
A \code{ped} object.
}
\description{
This function merges two ped objects, joining them at the individuals
with equal ID labels. This is especially useful for building 'top-heavy'
pedigrees. Only ped objects without marker data are supported.
}
\examples{

# Creating a trio where each parent have first cousin parents.
# (Alternatively, this could be built using many calls to addParents().)

# Paternal family
x = cousinPed(1, child = TRUE)
x = addSon(x, 9)

# Maternal family
y = cousinPed(1, child = TRUE)
y = relabel(y, c(101:108, 10))
y = swapSex(y, 10)

# Joining x and y at the common individuals (in this case: `10`)
z = mergePed(x, y)

# Plot all three pedigrees
opar = par(mfrow = c(1, 3))
plot(x); plot(y); plot(z, col = list(red = labels(y)))

# Reset graphical parameters
par(opar)

}
\author{
Magnus Dehli Vigeland
}
