% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mendelianCheck.R
\name{mendelianCheck}
\alias{mendelianCheck}
\title{Check for Mendelian errors}
\usage{
mendelianCheck(x, remove = FALSE, verbose = !remove)
}
\arguments{
\item{x}{a \code{\link[=ped]{ped()}} object}

\item{remove}{a logical. If FALSE, the function returns the indices of
markers found to incorrect.  If TRUE, a new \code{ped} object is
returned, where the incorrect markers have been deleted.}

\item{verbose}{a logical. If TRUE, details of the markers failing the tests
are shown.}
}
\value{
A numeric containing the indices of the markers
that did not pass all tests, or (if \code{remove = TRUE}) a new \code{ped}
object where the failing markers are removed.
}
\description{
Check marker data for Mendelian inconsistencies
}
\examples{

x = nuclearPed(3)

# Add a SNP with Mendelian error
m = marker(x, '1' = 1, '2' = 1, '3' = 1:2)
x = setMarkers(x, m)

mendelianCheck(x)

}
\author{
Magnus Dehli Vigeland
}
