% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_utils.R
\name{ped_utils}
\alias{ped_utils}
\alias{pedsize}
\alias{generations}
\alias{hasUnbrokenLoops}
\alias{hasInbredFounders}
\alias{hasSelfing}
\alias{hasCommonAncestor}
\alias{subnucs}
\alias{peelingOrder}
\title{Pedigree utilities}
\usage{
pedsize(x)

generations(x, maxComp = TRUE)

hasUnbrokenLoops(x)

hasInbredFounders(x, chromType = "autosomal")

hasSelfing(x)

hasCommonAncestor(x)

subnucs(x)

peelingOrder(x)
}
\arguments{
\item{x}{A \code{ped} object, or (in some functions - see Details) a list of such.}

\item{maxComp}{A logical, by default TRUE. See Value.}

\item{chromType}{Either "autosomal" (default) or "x".}
}
\value{
\itemize{
\item \code{pedsize(x)} returns the number of pedigree members in each component of
\code{x}.
\item \code{generations(x)} returns the number of generations in \code{x}, defined as the
number of individuals in the longest line of parent-child links. (Note that
this definition is valid also if \code{x} has loops.) If \code{x} has multiple
components, the output depends on the parameter \code{maxComp}. If this is FALSE,
the output is a vector containing the result for each component. If TRUE
(default), only the highest number is returned.
\item \code{hasUnbrokenLoops(x)} returns TRUE if \code{x} has loops, otherwise FALSE. (No
computation is done here; the function simply returns the value of
\code{x$UNBROKEN_LOOPS}).
\item \code{hasInbredFounders(x)} returns TRUE is founder inbreeding is specified for
\code{x} and at least one founder has positive inbreeding coefficient. See
\code{\link[=founderInbreeding]{founderInbreeding()}} for details.
\item \code{hasSelfing(x)} returns TRUE if the pedigree contains selfing events. This
is recognised by father and mother begin equal for some child. (Note that for
this to be allowed, the gender code of the parent must be 0.)
\item \code{hasCommonAncestor(x)} computes a logical matrix \code{A} whose entry \code{A[i,j]}
is TRUE if pedigree members i and j have a common ancestor in \code{x}, and FALSE
otherwise. By convention, \code{A[i,i]} is TRUE for all i.
\item \code{subnucs(x)} returns a list of all nuclear sub-pedigrees of \code{x}, wrapped as
\code{nucleus} objects. Each nucleus is a list with entries \code{father}, \code{mother} and
\code{children}.
\item \code{peelingOrder(x)} calls \code{subnucs(x)} and extends each entry with a \code{link}
individual, indicating a member linking the nucleus to the remaining
pedigree. One application of this function is the fact that if \emph{fails} to
find a complete peeling order if and only if the pedigree has loops. (In fact
it is called each time a new \code{ped} object is created by \code{\link[=ped]{ped()}} in order to
detect loops.) The main purpose of the function, however, is to prepare for
probability calculations in other packages, as e.g. in
\code{pedprobr::likelihood}.
}
}
\description{
Various utility functions for \code{ped} objects.
}
\examples{
x = fullSibMating(1)
stopifnot(pedsize(x) == 6)
stopifnot(hasUnbrokenLoops(x))
stopifnot(generations(x) == 3)

# All members have common ancestors except the grandparents
CA = hasCommonAncestor(x)
stopifnot(!CA[1,2], !CA[2,1], sum(CA) == length(CA) - 2)

# Effect of breaking the loop
y = breakLoops(x)
stopifnot(!hasUnbrokenLoops(y))
stopifnot(pedsize(y) == 7)

# A pedigree with selfing (note the necessary `sex = 0`)
z1 = singleton(1, sex = 0)
z2 = addChildren(z1, father = 1, mother = 1, nch = 1)
stopifnot(!hasSelfing(z1), hasSelfing(z2))

# Nucleus sub-pedigrees
stopifnot(length(subnucs(z1)) == 0)
peelingOrder(cousinPed(1))

}
