// Generated by rstantools.  Do not edit by hand.

/*
    pema is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    pema is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with pema.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_horseshoe_MA_ml_noint_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_horseshoe_MA_ml_noint");
    reader.add_event(105, 103, "end", "model_horseshoe_MA_ml_noint");
    return reader;
}
template <typename T0__, typename T1__, typename T2__, typename T3__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type, Eigen::Dynamic, 1>
horseshoe(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& z,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& lambda,
              const T2__& tau,
              const T3__& c2, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 14;
        int K(0);
        (void) K;  // dummy to suppress unused var warning
        stan::math::fill(K, std::numeric_limits<int>::min());
        stan::math::assign(K,rows(z));
        current_statement_begin__ = 15;
        validate_non_negative_index("lambda2", "K", K);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda2(K);
        stan::math::initialize(lambda2, DUMMY_VAR__);
        stan::math::fill(lambda2, DUMMY_VAR__);
        stan::math::assign(lambda2,square(lambda));
        current_statement_begin__ = 16;
        validate_non_negative_index("lambda_tilde", "K", K);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda_tilde(K);
        stan::math::initialize(lambda_tilde, DUMMY_VAR__);
        stan::math::fill(lambda_tilde, DUMMY_VAR__);
        stan::math::assign(lambda_tilde,stan::math::sqrt(elt_divide(multiply(c2, lambda2), add(c2, multiply(pow(tau, 2), lambda2)))));
        current_statement_begin__ = 17;
        return stan::math::promote_scalar<fun_return_scalar_t__>(multiply(elt_multiply(z, lambda_tilde), tau));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct horseshoe_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& z,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& lambda,
              const T2__& tau,
              const T3__& c2, std::ostream* pstream__) const {
        return horseshoe(z, lambda, tau, c2, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_horseshoe_MA_ml_noint
  : public stan::model::model_base_crtp<model_horseshoe_MA_ml_noint> {
private:
        int N;
        vector_d Y;
        vector_d se;
        int K;
        matrix_d X;
        double df;
        double df_global;
        double df_slab;
        double scale_global;
        double scale_slab;
        int N_1;
        int M_1;
        std::vector<int> J_1;
        vector_d Z_1_1;
        int N_2;
        int M_2;
        std::vector<int> J_2;
        vector_d Z_2_1;
        int prior_only;
        vector_d means_X;
        vector_d sds_X;
public:
    model_horseshoe_MA_ml_noint(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_horseshoe_MA_ml_noint(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_horseshoe_MA_ml_noint_namespace::model_horseshoe_MA_ml_noint";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 21;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 22;
            validate_non_negative_index("Y", "N", N);
            context__.validate_dims("data initialization", "Y", "vector_d", context__.to_vec(N));
            Y = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("Y");
            pos__ = 0;
            size_t Y_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < Y_j_1_max__; ++j_1__) {
                Y(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 23;
            validate_non_negative_index("se", "N", N);
            context__.validate_dims("data initialization", "se", "vector_d", context__.to_vec(N));
            se = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("se");
            pos__ = 0;
            size_t se_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < se_j_1_max__; ++j_1__) {
                se(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "se", se, 0);
            current_statement_begin__ = 24;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            check_greater_or_equal(function__, "K", K, 1);
            current_statement_begin__ = 25;
            validate_non_negative_index("X", "N", N);
            validate_non_negative_index("X", "K", K);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(N,K));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, K);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = K;
            size_t X_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 27;
            context__.validate_dims("data initialization", "df", "double", context__.to_vec());
            df = double(0);
            vals_r__ = context__.vals_r("df");
            pos__ = 0;
            df = vals_r__[pos__++];
            check_greater_or_equal(function__, "df", df, 0);
            current_statement_begin__ = 28;
            context__.validate_dims("data initialization", "df_global", "double", context__.to_vec());
            df_global = double(0);
            vals_r__ = context__.vals_r("df_global");
            pos__ = 0;
            df_global = vals_r__[pos__++];
            check_greater_or_equal(function__, "df_global", df_global, 0);
            current_statement_begin__ = 29;
            context__.validate_dims("data initialization", "df_slab", "double", context__.to_vec());
            df_slab = double(0);
            vals_r__ = context__.vals_r("df_slab");
            pos__ = 0;
            df_slab = vals_r__[pos__++];
            check_greater_or_equal(function__, "df_slab", df_slab, 0);
            current_statement_begin__ = 30;
            context__.validate_dims("data initialization", "scale_global", "double", context__.to_vec());
            scale_global = double(0);
            vals_r__ = context__.vals_r("scale_global");
            pos__ = 0;
            scale_global = vals_r__[pos__++];
            check_greater_or_equal(function__, "scale_global", scale_global, 0);
            current_statement_begin__ = 31;
            context__.validate_dims("data initialization", "scale_slab", "double", context__.to_vec());
            scale_slab = double(0);
            vals_r__ = context__.vals_r("scale_slab");
            pos__ = 0;
            scale_slab = vals_r__[pos__++];
            check_greater_or_equal(function__, "scale_slab", scale_slab, 0);
            current_statement_begin__ = 33;
            context__.validate_dims("data initialization", "N_1", "int", context__.to_vec());
            N_1 = int(0);
            vals_i__ = context__.vals_i("N_1");
            pos__ = 0;
            N_1 = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_1", N_1, 1);
            current_statement_begin__ = 34;
            context__.validate_dims("data initialization", "M_1", "int", context__.to_vec());
            M_1 = int(0);
            vals_i__ = context__.vals_i("M_1");
            pos__ = 0;
            M_1 = vals_i__[pos__++];
            check_greater_or_equal(function__, "M_1", M_1, 1);
            current_statement_begin__ = 35;
            validate_non_negative_index("J_1", "N", N);
            context__.validate_dims("data initialization", "J_1", "int", context__.to_vec(N));
            J_1 = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("J_1");
            pos__ = 0;
            size_t J_1_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < J_1_k_0_max__; ++k_0__) {
                J_1[k_0__] = vals_i__[pos__++];
            }
            size_t J_1_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < J_1_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "J_1[i_0__]", J_1[i_0__], 1);
            }
            current_statement_begin__ = 37;
            validate_non_negative_index("Z_1_1", "N", N);
            context__.validate_dims("data initialization", "Z_1_1", "vector_d", context__.to_vec(N));
            Z_1_1 = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("Z_1_1");
            pos__ = 0;
            size_t Z_1_1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < Z_1_1_j_1_max__; ++j_1__) {
                Z_1_1(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 39;
            context__.validate_dims("data initialization", "N_2", "int", context__.to_vec());
            N_2 = int(0);
            vals_i__ = context__.vals_i("N_2");
            pos__ = 0;
            N_2 = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_2", N_2, 1);
            current_statement_begin__ = 40;
            context__.validate_dims("data initialization", "M_2", "int", context__.to_vec());
            M_2 = int(0);
            vals_i__ = context__.vals_i("M_2");
            pos__ = 0;
            M_2 = vals_i__[pos__++];
            check_greater_or_equal(function__, "M_2", M_2, 1);
            current_statement_begin__ = 41;
            validate_non_negative_index("J_2", "N", N);
            context__.validate_dims("data initialization", "J_2", "int", context__.to_vec(N));
            J_2 = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("J_2");
            pos__ = 0;
            size_t J_2_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < J_2_k_0_max__; ++k_0__) {
                J_2[k_0__] = vals_i__[pos__++];
            }
            size_t J_2_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < J_2_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "J_2[i_0__]", J_2[i_0__], 1);
            }
            current_statement_begin__ = 43;
            validate_non_negative_index("Z_2_1", "N", N);
            context__.validate_dims("data initialization", "Z_2_1", "vector_d", context__.to_vec(N));
            Z_2_1 = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("Z_2_1");
            pos__ = 0;
            size_t Z_2_1_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < Z_2_1_j_1_max__; ++j_1__) {
                Z_2_1(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 44;
            context__.validate_dims("data initialization", "prior_only", "int", context__.to_vec());
            prior_only = int(0);
            vals_i__ = context__.vals_i("prior_only");
            pos__ = 0;
            prior_only = vals_i__[pos__++];
            current_statement_begin__ = 45;
            validate_non_negative_index("means_X", "K", K);
            context__.validate_dims("data initialization", "means_X", "vector_d", context__.to_vec(K));
            means_X = Eigen::Matrix<double, Eigen::Dynamic, 1>(K);
            vals_r__ = context__.vals_r("means_X");
            pos__ = 0;
            size_t means_X_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < means_X_j_1_max__; ++j_1__) {
                means_X(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 46;
            validate_non_negative_index("sds_X", "K", K);
            context__.validate_dims("data initialization", "sds_X", "vector_d", context__.to_vec(K));
            sds_X = Eigen::Matrix<double, Eigen::Dynamic, 1>(K);
            vals_r__ = context__.vals_r("sds_X");
            pos__ = 0;
            size_t sds_X_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < sds_X_j_1_max__; ++j_1__) {
                sds_X(j_1__) = vals_r__[pos__++];
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 50;
            validate_non_negative_index("zb", "K", K);
            num_params_r__ += K;
            current_statement_begin__ = 51;
            validate_non_negative_index("hs_local", "K", K);
            num_params_r__ += K;
            current_statement_begin__ = 52;
            num_params_r__ += 1;
            current_statement_begin__ = 54;
            num_params_r__ += 1;
            current_statement_begin__ = 55;
            num_params_r__ += 1;
            current_statement_begin__ = 56;
            validate_non_negative_index("sd_1", "M_1", M_1);
            num_params_r__ += M_1;
            current_statement_begin__ = 57;
            validate_non_negative_index("z_1", "N_1", N_1);
            validate_non_negative_index("z_1", "M_1", M_1);
            num_params_r__ += (N_1 * M_1);
            current_statement_begin__ = 58;
            validate_non_negative_index("sd_2", "M_2", M_2);
            num_params_r__ += M_2;
            current_statement_begin__ = 59;
            validate_non_negative_index("z_2", "N_2", N_2);
            validate_non_negative_index("z_2", "M_2", M_2);
            num_params_r__ += (N_2 * M_2);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_horseshoe_MA_ml_noint() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 50;
        if (!(context__.contains_r("zb")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable zb missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("zb");
        pos__ = 0U;
        validate_non_negative_index("zb", "K", K);
        context__.validate_dims("parameter initialization", "zb", "vector_d", context__.to_vec(K));
        Eigen::Matrix<double, Eigen::Dynamic, 1> zb(K);
        size_t zb_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < zb_j_1_max__; ++j_1__) {
            zb(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(zb);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable zb: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 51;
        if (!(context__.contains_r("hs_local")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable hs_local missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("hs_local");
        pos__ = 0U;
        validate_non_negative_index("hs_local", "K", K);
        context__.validate_dims("parameter initialization", "hs_local", "vector_d", context__.to_vec(K));
        Eigen::Matrix<double, Eigen::Dynamic, 1> hs_local(K);
        size_t hs_local_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < hs_local_j_1_max__; ++j_1__) {
            hs_local(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, hs_local);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable hs_local: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 52;
        if (!(context__.contains_r("Int_c")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable Int_c missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("Int_c");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "Int_c", "double", context__.to_vec());
        double Int_c(0);
        Int_c = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(Int_c);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable Int_c: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 54;
        if (!(context__.contains_r("hs_global")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable hs_global missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("hs_global");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "hs_global", "double", context__.to_vec());
        double hs_global(0);
        hs_global = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, hs_global);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable hs_global: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 55;
        if (!(context__.contains_r("hs_slab")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable hs_slab missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("hs_slab");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "hs_slab", "double", context__.to_vec());
        double hs_slab(0);
        hs_slab = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, hs_slab);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable hs_slab: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 56;
        if (!(context__.contains_r("sd_1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sd_1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sd_1");
        pos__ = 0U;
        validate_non_negative_index("sd_1", "M_1", M_1);
        context__.validate_dims("parameter initialization", "sd_1", "vector_d", context__.to_vec(M_1));
        Eigen::Matrix<double, Eigen::Dynamic, 1> sd_1(M_1);
        size_t sd_1_j_1_max__ = M_1;
        for (size_t j_1__ = 0; j_1__ < sd_1_j_1_max__; ++j_1__) {
            sd_1(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, sd_1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sd_1: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 57;
        if (!(context__.contains_r("z_1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable z_1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("z_1");
        pos__ = 0U;
        validate_non_negative_index("z_1", "N_1", N_1);
        validate_non_negative_index("z_1", "M_1", M_1);
        context__.validate_dims("parameter initialization", "z_1", "vector_d", context__.to_vec(M_1,N_1));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > z_1(M_1, Eigen::Matrix<double, Eigen::Dynamic, 1>(N_1));
        size_t z_1_j_1_max__ = N_1;
        size_t z_1_k_0_max__ = M_1;
        for (size_t j_1__ = 0; j_1__ < z_1_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < z_1_k_0_max__; ++k_0__) {
                z_1[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t z_1_i_0_max__ = M_1;
        for (size_t i_0__ = 0; i_0__ < z_1_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(z_1[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable z_1: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 58;
        if (!(context__.contains_r("sd_2")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sd_2 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sd_2");
        pos__ = 0U;
        validate_non_negative_index("sd_2", "M_2", M_2);
        context__.validate_dims("parameter initialization", "sd_2", "vector_d", context__.to_vec(M_2));
        Eigen::Matrix<double, Eigen::Dynamic, 1> sd_2(M_2);
        size_t sd_2_j_1_max__ = M_2;
        for (size_t j_1__ = 0; j_1__ < sd_2_j_1_max__; ++j_1__) {
            sd_2(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, sd_2);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sd_2: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 59;
        if (!(context__.contains_r("z_2")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable z_2 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("z_2");
        pos__ = 0U;
        validate_non_negative_index("z_2", "N_2", N_2);
        validate_non_negative_index("z_2", "M_2", M_2);
        context__.validate_dims("parameter initialization", "z_2", "vector_d", context__.to_vec(M_2,N_2));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > z_2(M_2, Eigen::Matrix<double, Eigen::Dynamic, 1>(N_2));
        size_t z_2_j_1_max__ = N_2;
        size_t z_2_k_0_max__ = M_2;
        for (size_t j_1__ = 0; j_1__ < z_2_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < z_2_k_0_max__; ++k_0__) {
                z_2[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t z_2_i_0_max__ = M_2;
        for (size_t i_0__ = 0; i_0__ < z_2_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(z_2[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable z_2: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 50;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> zb;
            (void) zb;  // dummy to suppress unused var warning
            if (jacobian__)
                zb = in__.vector_constrain(K, lp__);
            else
                zb = in__.vector_constrain(K);
            current_statement_begin__ = 51;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> hs_local;
            (void) hs_local;  // dummy to suppress unused var warning
            if (jacobian__)
                hs_local = in__.vector_lb_constrain(0, K, lp__);
            else
                hs_local = in__.vector_lb_constrain(0, K);
            current_statement_begin__ = 52;
            local_scalar_t__ Int_c;
            (void) Int_c;  // dummy to suppress unused var warning
            if (jacobian__)
                Int_c = in__.scalar_constrain(lp__);
            else
                Int_c = in__.scalar_constrain();
            current_statement_begin__ = 54;
            local_scalar_t__ hs_global;
            (void) hs_global;  // dummy to suppress unused var warning
            if (jacobian__)
                hs_global = in__.scalar_lb_constrain(0, lp__);
            else
                hs_global = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 55;
            local_scalar_t__ hs_slab;
            (void) hs_slab;  // dummy to suppress unused var warning
            if (jacobian__)
                hs_slab = in__.scalar_lb_constrain(0, lp__);
            else
                hs_slab = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 56;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sd_1;
            (void) sd_1;  // dummy to suppress unused var warning
            if (jacobian__)
                sd_1 = in__.vector_lb_constrain(0, M_1, lp__);
            else
                sd_1 = in__.vector_lb_constrain(0, M_1);
            current_statement_begin__ = 57;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > z_1;
            size_t z_1_d_0_max__ = M_1;
            z_1.reserve(z_1_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < z_1_d_0_max__; ++d_0__) {
                if (jacobian__)
                    z_1.push_back(in__.vector_constrain(N_1, lp__));
                else
                    z_1.push_back(in__.vector_constrain(N_1));
            }
            current_statement_begin__ = 58;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sd_2;
            (void) sd_2;  // dummy to suppress unused var warning
            if (jacobian__)
                sd_2 = in__.vector_lb_constrain(0, M_2, lp__);
            else
                sd_2 = in__.vector_lb_constrain(0, M_2);
            current_statement_begin__ = 59;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > z_2;
            size_t z_2_d_0_max__ = M_2;
            z_2.reserve(z_2_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < z_2_d_0_max__; ++d_0__) {
                if (jacobian__)
                    z_2.push_back(in__.vector_constrain(N_2, lp__));
                else
                    z_2.push_back(in__.vector_constrain(N_2));
            }
            // transformed parameters
            current_statement_begin__ = 62;
            validate_non_negative_index("b", "K", K);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> b(K);
            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b, DUMMY_VAR__);
            current_statement_begin__ = 63;
            validate_non_negative_index("r_1_1", "N_1", N_1);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> r_1_1(N_1);
            stan::math::initialize(r_1_1, DUMMY_VAR__);
            stan::math::fill(r_1_1, DUMMY_VAR__);
            current_statement_begin__ = 64;
            validate_non_negative_index("r_2_1", "N_2", N_2);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> r_2_1(N_2);
            stan::math::initialize(r_2_1, DUMMY_VAR__);
            stan::math::fill(r_2_1, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 65;
            stan::math::assign(r_1_1, multiply(get_base1(sd_1, 1, "sd_1", 1), get_base1(z_1, 1, "z_1", 1)));
            current_statement_begin__ = 66;
            stan::math::assign(r_2_1, multiply(get_base1(sd_2, 1, "sd_2", 1), get_base1(z_2, 1, "z_2", 1)));
            current_statement_begin__ = 68;
            stan::math::assign(b, horseshoe(zb, hs_local, hs_global, (pow(scale_slab, 2) * hs_slab), pstream__));
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 62;
            size_t b_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(b(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: b" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable b: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 63;
            size_t r_1_1_j_1_max__ = N_1;
            for (size_t j_1__ = 0; j_1__ < r_1_1_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(r_1_1(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: r_1_1" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable r_1_1: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 64;
            size_t r_2_1_j_1_max__ = N_2;
            for (size_t j_1__ = 0; j_1__ < r_2_1_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(r_2_1(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: r_2_1" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable r_2_1: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 72;
            if (as_bool(logical_negation(prior_only))) {
                {
                current_statement_begin__ = 74;
                validate_non_negative_index("mu", "N", N);
                Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(N);
                stan::math::initialize(mu, DUMMY_VAR__);
                stan::math::fill(mu, DUMMY_VAR__);
                stan::math::assign(mu,multiply(X, b));
                current_statement_begin__ = 75;
                for (int n = 1; n <= N; ++n) {
                    current_statement_begin__ = 77;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                                (stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), "mu") + ((get_base1(r_1_1, get_base1(J_1, n, "J_1", 1), "r_1_1", 1) * get_base1(Z_1_1, n, "Z_1_1", 1)) + (get_base1(r_2_1, get_base1(J_2, n, "J_2", 1), "r_2_1", 1) * get_base1(Z_2_1, n, "Z_2_1", 1)))), 
                                "assigning variable mu");
                }
                current_statement_begin__ = 79;
                lp_accum__.add(normal_log(Y, mu, se));
                }
            }
            current_statement_begin__ = 82;
            lp_accum__.add(std_normal_log(zb));
            current_statement_begin__ = 83;
            lp_accum__.add((student_t_log(hs_local, df, 0, 1) - (rows(hs_local) * stan::math::log(0.5))));
            current_statement_begin__ = 85;
            lp_accum__.add((student_t_log(hs_global, df_global, 0, scale_global) - (1 * stan::math::log(0.5))));
            current_statement_begin__ = 87;
            lp_accum__.add(inv_gamma_log(hs_slab, (0.5 * df_slab), (0.5 * df_slab)));
            current_statement_begin__ = 92;
            lp_accum__.add((student_t_log(sd_1, 3, 0, 2.5) - (1 * student_t_ccdf_log(0, 3, 0, 2.5))));
            current_statement_begin__ = 94;
            lp_accum__.add((student_t_log(sd_2, 3, 0, 2.5) - (1 * student_t_ccdf_log(0, 3, 0, 2.5))));
            current_statement_begin__ = 96;
            lp_accum__.add(std_normal_log(get_base1(z_1, 1, "z_1", 1)));
            current_statement_begin__ = 97;
            lp_accum__.add(std_normal_log(get_base1(z_2, 1, "z_2", 1)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("zb");
        names__.push_back("hs_local");
        names__.push_back("Int_c");
        names__.push_back("hs_global");
        names__.push_back("hs_slab");
        names__.push_back("sd_1");
        names__.push_back("z_1");
        names__.push_back("sd_2");
        names__.push_back("z_2");
        names__.push_back("b");
        names__.push_back("r_1_1");
        names__.push_back("r_2_1");
        names__.push_back("betas");
        names__.push_back("tau2_w");
        names__.push_back("tau2_b");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M_1);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M_1);
        dims__.push_back(N_1);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M_2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(M_2);
        dims__.push_back(N_2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_1);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_horseshoe_MA_ml_noint_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> zb = in__.vector_constrain(K);
        size_t zb_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < zb_j_1_max__; ++j_1__) {
            vars__.push_back(zb(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> hs_local = in__.vector_lb_constrain(0, K);
        size_t hs_local_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < hs_local_j_1_max__; ++j_1__) {
            vars__.push_back(hs_local(j_1__));
        }
        double Int_c = in__.scalar_constrain();
        vars__.push_back(Int_c);
        double hs_global = in__.scalar_lb_constrain(0);
        vars__.push_back(hs_global);
        double hs_slab = in__.scalar_lb_constrain(0);
        vars__.push_back(hs_slab);
        Eigen::Matrix<double, Eigen::Dynamic, 1> sd_1 = in__.vector_lb_constrain(0, M_1);
        size_t sd_1_j_1_max__ = M_1;
        for (size_t j_1__ = 0; j_1__ < sd_1_j_1_max__; ++j_1__) {
            vars__.push_back(sd_1(j_1__));
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > z_1;
        size_t z_1_d_0_max__ = M_1;
        z_1.reserve(z_1_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < z_1_d_0_max__; ++d_0__) {
            z_1.push_back(in__.vector_constrain(N_1));
        }
        size_t z_1_j_1_max__ = N_1;
        size_t z_1_k_0_max__ = M_1;
        for (size_t j_1__ = 0; j_1__ < z_1_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < z_1_k_0_max__; ++k_0__) {
                vars__.push_back(z_1[k_0__](j_1__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> sd_2 = in__.vector_lb_constrain(0, M_2);
        size_t sd_2_j_1_max__ = M_2;
        for (size_t j_1__ = 0; j_1__ < sd_2_j_1_max__; ++j_1__) {
            vars__.push_back(sd_2(j_1__));
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > z_2;
        size_t z_2_d_0_max__ = M_2;
        z_2.reserve(z_2_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < z_2_d_0_max__; ++d_0__) {
            z_2.push_back(in__.vector_constrain(N_2));
        }
        size_t z_2_j_1_max__ = N_2;
        size_t z_2_k_0_max__ = M_2;
        for (size_t j_1__ = 0; j_1__ < z_2_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < z_2_k_0_max__; ++k_0__) {
                vars__.push_back(z_2[k_0__](j_1__));
            }
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 62;
            validate_non_negative_index("b", "K", K);
            Eigen::Matrix<double, Eigen::Dynamic, 1> b(K);
            stan::math::initialize(b, DUMMY_VAR__);
            stan::math::fill(b, DUMMY_VAR__);
            current_statement_begin__ = 63;
            validate_non_negative_index("r_1_1", "N_1", N_1);
            Eigen::Matrix<double, Eigen::Dynamic, 1> r_1_1(N_1);
            stan::math::initialize(r_1_1, DUMMY_VAR__);
            stan::math::fill(r_1_1, DUMMY_VAR__);
            current_statement_begin__ = 64;
            validate_non_negative_index("r_2_1", "N_2", N_2);
            Eigen::Matrix<double, Eigen::Dynamic, 1> r_2_1(N_2);
            stan::math::initialize(r_2_1, DUMMY_VAR__);
            stan::math::fill(r_2_1, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 65;
            stan::math::assign(r_1_1, multiply(get_base1(sd_1, 1, "sd_1", 1), get_base1(z_1, 1, "z_1", 1)));
            current_statement_begin__ = 66;
            stan::math::assign(r_2_1, multiply(get_base1(sd_2, 1, "sd_2", 1), get_base1(z_2, 1, "z_2", 1)));
            current_statement_begin__ = 68;
            stan::math::assign(b, horseshoe(zb, hs_local, hs_global, (pow(scale_slab, 2) * hs_slab), pstream__));
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t b_j_1_max__ = K;
                for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                    vars__.push_back(b(j_1__));
                }
                size_t r_1_1_j_1_max__ = N_1;
                for (size_t j_1__ = 0; j_1__ < r_1_1_j_1_max__; ++j_1__) {
                    vars__.push_back(r_1_1(j_1__));
                }
                size_t r_2_1_j_1_max__ = N_2;
                for (size_t j_1__ = 0; j_1__ < r_2_1_j_1_max__; ++j_1__) {
                    vars__.push_back(r_2_1(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 100;
            validate_non_negative_index("betas", "K", K);
            Eigen::Matrix<double, Eigen::Dynamic, 1> betas(K);
            stan::math::initialize(betas, DUMMY_VAR__);
            stan::math::fill(betas, DUMMY_VAR__);
            stan::math::assign(betas,elt_divide(b, sds_X));
            current_statement_begin__ = 101;
            double tau2_w;
            (void) tau2_w;  // dummy to suppress unused var warning
            stan::math::initialize(tau2_w, DUMMY_VAR__);
            stan::math::fill(tau2_w, DUMMY_VAR__);
            stan::math::assign(tau2_w,pow(get_base1(sd_1, 1, "sd_1", 1), 2));
            current_statement_begin__ = 102;
            double tau2_b;
            (void) tau2_b;  // dummy to suppress unused var warning
            stan::math::initialize(tau2_b, DUMMY_VAR__);
            stan::math::fill(tau2_b, DUMMY_VAR__);
            stan::math::assign(tau2_b,pow(get_base1(sd_2, 1, "sd_2", 1), 2));
            // validate, write generated quantities
            current_statement_begin__ = 100;
            size_t betas_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < betas_j_1_max__; ++j_1__) {
                vars__.push_back(betas(j_1__));
            }
            current_statement_begin__ = 101;
            vars__.push_back(tau2_w);
            current_statement_begin__ = 102;
            vars__.push_back(tau2_b);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_horseshoe_MA_ml_noint";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t zb_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < zb_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zb" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t hs_local_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < hs_local_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "hs_local" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "Int_c";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "hs_global";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "hs_slab";
        param_names__.push_back(param_name_stream__.str());
        size_t sd_1_j_1_max__ = M_1;
        for (size_t j_1__ = 0; j_1__ < sd_1_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sd_1" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_1_j_1_max__ = N_1;
        size_t z_1_k_0_max__ = M_1;
        for (size_t j_1__ = 0; j_1__ < z_1_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < z_1_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z_1" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t sd_2_j_1_max__ = M_2;
        for (size_t j_1__ = 0; j_1__ < sd_2_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sd_2" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_2_j_1_max__ = N_2;
        size_t z_2_k_0_max__ = M_2;
        for (size_t j_1__ = 0; j_1__ < z_2_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < z_2_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z_2" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t b_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t r_1_1_j_1_max__ = N_1;
            for (size_t j_1__ = 0; j_1__ < r_1_1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "r_1_1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t r_2_1_j_1_max__ = N_2;
            for (size_t j_1__ = 0; j_1__ < r_2_1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "r_2_1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t betas_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < betas_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "betas" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau2_w";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau2_b";
        param_names__.push_back(param_name_stream__.str());
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t zb_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < zb_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "zb" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t hs_local_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < hs_local_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "hs_local" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "Int_c";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "hs_global";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "hs_slab";
        param_names__.push_back(param_name_stream__.str());
        size_t sd_1_j_1_max__ = M_1;
        for (size_t j_1__ = 0; j_1__ < sd_1_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sd_1" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_1_j_1_max__ = N_1;
        size_t z_1_k_0_max__ = M_1;
        for (size_t j_1__ = 0; j_1__ < z_1_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < z_1_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z_1" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t sd_2_j_1_max__ = M_2;
        for (size_t j_1__ = 0; j_1__ < sd_2_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sd_2" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t z_2_j_1_max__ = N_2;
        size_t z_2_k_0_max__ = M_2;
        for (size_t j_1__ = 0; j_1__ < z_2_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < z_2_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "z_2" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t b_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "b" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t r_1_1_j_1_max__ = N_1;
            for (size_t j_1__ = 0; j_1__ < r_1_1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "r_1_1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t r_2_1_j_1_max__ = N_2;
            for (size_t j_1__ = 0; j_1__ < r_2_1_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "r_2_1" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t betas_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < betas_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "betas" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau2_w";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau2_b";
        param_names__.push_back(param_name_stream__.str());
    }
}; // model
}  // namespace
typedef model_horseshoe_MA_ml_noint_namespace::model_horseshoe_MA_ml_noint stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
