% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsample.clr.R
\name{subsample.clr}
\alias{subsample.clr}
\title{Stability selection for penalized conditional logistic regression}
\usage{
subsample.clr(
  response,
  stratum,
  penalized,
  unpenalized = NULL,
  lambda,
  alpha = 1,
  B = 100,
  matB = NULL,
  return.matB = FALSE,
  parallel = TRUE,
  standardize = FALSE
)
}
\arguments{
\item{response}{The response variable, either a 0/1 vector or a factor with two levels.}

\item{stratum}{A numeric vector with stratum membership of each observation.}

\item{penalized}{A matrix of penalized covariates.}

\item{unpenalized}{A matrix of additional unpenalized covariates.}

\item{lambda}{The tuning parameter for L1. Either a single non-negative number,
or a numeric vector of the length equal to the number of blocks. If NULL, function \code{find.default.lambda} is called.  See p below.}

\item{alpha}{The elastic net mixing parameter, a number between 0 and 1.
alpha=0 would give pure ridge; alpha=1 gives lasso. Pure ridge penalty is never obtained in this implementation since alpha must be positive.}

\item{B}{A single positive number for the number of subsamples.}

\item{matB}{A 2B x ceiling(unique(stratum)/2) matrix with index set of selected strata in each of 2B subsamples}

\item{return.matB}{Logical. Should the matrix matB be returned?}

\item{parallel}{Logical. Should the computation be parallelized?}

\item{standardize}{Should the covariates be standardized, a logical value.}
}
\value{
If \code{return.matB} is TRUE, a list with two elements, a numeric vector Pilambda,
giving selection probabilities for each covariate and a matrix \code{matB};
otheriwise only Pilambda.
}
\description{
Stability selection for penalized conditional logistic regression
}
