% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{plot.cv_elnetfit}
\alias{plot.cv_elnetfit}
\title{Plot Method for Cross-Validated Elastic Net Models}
\usage{
\method{plot}{cv_elnetfit}(x, what = c("cv", "coef.path"), ...)
}
\arguments{
\item{x}{a fitted, cross-validated EN model from \code{\link{elnet_cv}}.}

\item{what}{plot either the cross-validated prediction error
(\code{"cv"}; default) or the coefficient paths.}

\item{...}{currently ignored.}
}
\description{
Plot the cross-validation error or the coefficient path for a fitted
elastic net regression model.
}
\examples{
# Generate data with highly correlated groups of variables
set.seed(12345)
n <- 100
p <- 20
x <- 1 + matrix(rnorm(n * p), ncol = p)
x[, 2] <- x[, 1] + rnorm(n, sd = 0.01)
x[, 3] <- x[, 1] + rnorm(n, sd = 0.01)
x[, 5] <- x[, 4] + rnorm(n, sd = 0.01)
x[, 6] <- x[, 4] + rnorm(n, sd = 0.01)

y <- x \%*\% c(rep(c(2, 5), each = 3), numeric(p - 6)) + rnorm(n)

# Compute the classical EN and select the optimal lambda by CV
set.seed(1234)
est_en <- elnet_cv(
    x, y,
    alpha = 0.5
)

# By default, `plot` shows the CV prediction error
plot(est_en)
# We can also plot the coefficient paths
plot(est_en, what = "coef.path")

# Compute the LASSO solution
set.seed(1234)
est_lasso <- elnet_cv(
    x, y,
    alpha = 1
)

plot(est_lasso)
plot(est_lasso, what = "coef.path")
}
