% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_options.R
\name{enpy_options}
\alias{enpy_options}
\title{Options for the ENPY Algorithm}
\usage{
enpy_options(
  max_it = 10,
  keep_psc_proportion = 0.5,
  en_algorithm_opts,
  keep_residuals_measure = c("threshold", "proportion"),
  keep_residuals_proportion = 0.5,
  keep_residuals_threshold = 2,
  retain_best_factor = 2,
  retain_max = 500
)
}
\arguments{
\item{max_it}{maximum number of EN-PY iterations.}

\item{keep_psc_proportion}{how many observations should to keep based on the Principal Sensitivity Components.}

\item{en_algorithm_opts}{options for the LS-EN algorithm. See \link{en_algorithm_options} for details.}

\item{keep_residuals_measure}{how to determine what observations to keep, based on their residuals.
If \code{proportion}, a fixed number of observations is kept.
If \code{threshold}, only observations with residuals below the threshold are kept.}

\item{keep_residuals_proportion}{proportion of observations to kept based on their residuals.}

\item{keep_residuals_threshold}{only observations with (standardized) residuals less than this threshold are kept.}

\item{retain_best_factor}{only keep candidates that are within this factor of the best candidate. If \verb{<= 1}, only
keep candidates from the last iteration.}

\item{retain_max}{maximum number of candidates, i.e., only the best \code{retain_max} candidates are retained.}
}
\value{
options for the ENPY algorithm.
}
\description{
Additional control options for the elastic net Peña-Yohai procedure.
}
\details{
The EN-PY procedure for computing initial estimates iteratively cleans the data of observations with possibly
outlying residual or high leverage. Least-squares elastic net (LS-EN) estimates are computed on the possibly clean
subsets. At each iteration, the Principal Sensitivity Components are computed to remove observations with potentially
high leverage. Among all the LS-EN estimates, the estimate with smallest M-scale of the residuals is selected.
Observations with largest residual for the selected estimate are removed and the next iteration is started.
}
