% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_SNV.R
\name{orderSNVs}
\alias{orderSNVs}
\title{Order SNVs}
\usage{
orderSNVs(snvWin)
}
\arguments{
\item{snvWin}{See the arguments in \code{\link{buildDend}}}
}
\value{
A hapMat with ordered SNVs.
}
\description{
This function orders the SNVs in the window around the SNV.
}
\details{
Following Gusfield (1991), the first step in building the dendogram is to order compatible SNVs by
their ancestry. Then, following Mailund et al. (2006) the incompatible SNVs are ordered according
to their proximity to the focal SNV.
}
\examples{

\dontshow{

data(ex_hapMatSmall_data)

# First select a window of SNVs about a focal SNV.

SNV_win <- selectWindow(hapMat = ex_hapMatSmall_data,
                       focalSNV = 10, minWindow = 1)
                       
# Then, order the selected window of SNVs around the focal SNV.

 ordSNVwin <- orderSNVs(snvWin = SNV_win)

}

}
\references{
Gusfield, D. (1991). Efficient algorithms for inferring evolutionary trees.
             Networks, 21(1), 19-28.

Mailund, T., Besenbacher, S., & Schierup, M. H. (2006). Whole genome association
             mapping by incompatibilities and local perfect phylogenies. BMC Bioinformatics, 7(1),
             454.
}
\seealso{
\code{\link{buildDend}}, \code{\link{orderColsAncestry}}
}
\keyword{internal}
