% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_zeroinflation.R
\name{check_zeroinflation}
\alias{check_zeroinflation}
\title{Check for zero-inflation in count models}
\usage{
check_zeroinflation(x, tolerance = 0.05)
}
\arguments{
\item{x}{Fitted model of class \code{merMod}, \code{glmmTMB}, \code{glm},
or \code{glm.nb} (package \pkg{MASS}).}

\item{tolerance}{The tolerance for the ratio of observed and predicted
zeros to considered as over- or underfitting zeros. A ratio
between 1 +/- \code{tolerance} is considered as OK, while a ratio
beyond or below this treshold would indicate over- or underfitting.}
}
\value{
A list with information about the amount of predicted and observed
   zeros in the outcome, as well as the ratio between these two values.
}
\description{
\code{check_zeroinflation()} checks whether count models are over- or
   underfitting zeros in the outcome.
}
\details{
If the amount of observed zeros is larger than the amount of
  predicted zeros, the model is underfitting zeros, which indicates a
  zero-inflation in the data. In such cases, it is recommended to use
  negative binomial or zero-inflated models.
}
\examples{
library(glmmTMB)
data(Salamanders)
m <- glm(count ~ spp + mined, family = poisson, data = Salamanders)
check_zeroinflation(m)
}
