% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_tjur.R
\name{r2_tjur}
\alias{r2_tjur}
\title{Tjur's R2 - coefficient of determination (D)}
\usage{
r2_tjur(model)
}
\arguments{
\item{model}{Binomial Model.}
}
\value{
A named vector with the R2 value.
}
\description{
This method calculates the Coefficient of Discrimination \code{D}
  (also known as Tjur's R2; \cite{Tjur, 2009}) for generalized linear (mixed) models
  for binary outcomes. It is an alternative to other pseudo-R2 values like
  Nagelkerke's R2 or Cox-Snell R2. The Coefficient of Discrimination \code{D}
  can be read like any other (pseudo-)R2 value.
}
\examples{
model <- glm(vs ~ wt + mpg, data = mtcars, family = "binomial")
r2_tjur(model)
}
\references{
Tjur, T. (2009). Coefficients of determination in logistic regression models - A new proposal: The coefficient of discrimination. The American Statistician, 63(4), 366-372.
}
