% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_helpers.R
\name{add_ui_sidebar_advanced}
\alias{add_ui_sidebar_advanced}
\title{Add UI Elements to the Sidebar (Advanced Tab)}
\usage{
add_ui_sidebar_advanced(
  elementlist = NULL,
  append = FALSE,
  tabname = "Advanced"
)
}
\arguments{
\item{elementlist}{list of UI elements to add to the sidebar tab}

\item{append}{whether to append the \code{elementlist} to the currently
registered elements or replace the currently registered elements completely}

\item{tabname}{change the label on the UI tab (default = "Advanced")}
}
\description{
This function registers UI elements to the secondary (rear-most) tab
on the dashboard sidebar.  The default name of the tab is \strong{Advanced}
but can be renamed using the tabname argument.
}
\section{Shiny Usage}{

Call this function after creating elements in \code{program/ui_sidebar.R} to register
them to the application framework and show them on the Advanced tab in the
dashboard sidebar
}

\examples{
require(shiny)

s1 <- selectInput("sample1", "A Select", c("A", "B", "C"))
s2 <- radioButtons("sample2", NULL, c("A", "B", "C"))

add_ui_sidebar_advanced(list(s1, s2), append = FALSE)

}
\seealso{
\link[periscope]{add_ui_sidebar_basic}

\link[periscope]{add_ui_body}
}
