% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depTrun.R
\name{permDep}
\alias{permDep}
\title{Permutation test for general dependent truncation}
\usage{
permDep(trun, obs, permSize, cens, sampling = c("conditional",
  "unconditional", "is.conditional", "is.unconditional"), kendallOnly = FALSE,
  minp1Only = FALSE, minp2Only = FALSE, nc = ceiling(detectCores()/2),
  seed = NULL)
}
\arguments{
\item{trun}{is the left truncation time.}

\item{obs}{is the observed failure time.}

\item{permSize}{is the number of permutations.}

\item{cens}{is the status indicator; 0 = censored, 1 = event.}

\item{sampling}{a character string specifying the sampling method used in permutation.
The following are permitted:
\describe{
\item{\code{conditional}}{conditional permutation;}
\item{\code{uconditional}}{unconditional permutation;}
\item{\code{is.conditional}}{importance sampling version of conditional permutation;}
\item{\code{is.uconditional}}{importance sampling version of unconditional permutation;}
}}

\item{kendallOnly, minp1Only, minp2Only}{optional values indicating which test statistics to be used.
If all leave as \code{FALSE}, \code{permDep} will use all three test statistics in each permutation.}

\item{nc}{is the number of cores used in permutation.
When \code{nc > 1}, permutation is carried out with parallel computing.}

\item{seed}{an optional vector containing random seeds to be used to generate permutation samples.
Random seeds will be used when left unspecified.}
}
\value{
A list containing output with the following components:
\describe{
\item{obsKen}{the observed p-value using Kendall's tau test statistic.}
\item{obsP1}{the observed p-value using minp1 test statistic.}
\item{obsP2}{the observed p-value using minp2 test statistic.}
\item{obsTest1}{the observed minp1 test statistic.}
\item{obsTest2}{the observed minp2 test statistic.}
\item{permKen}{Kendall's tau test statistics from permutation samples.}
\item{permP1}{minp1 test statistics from permutation samples.}
\item{permP2}{minp2 test statistics from permutation samples.}
}
}
\description{
Perform permutation test based on conditional or unconditional approach.
}
\examples{
simDat <- function(n) {
  k <- s <- 1
  tt <- xx <- yy <- cc <- delta <- rep(-1, n)
  while(k <= n){
    tt[k] <- runif(1, 0, 3.5)
    xx[k] <- 1.95 + 0.65 * (tt[k] - 1.25)^2 + rnorm(1, sd = 0.1)
    cc[k] <- runif(1, 0, 10)
    delta[k] <- (xx[k] <= cc[k])
    yy[k] <- pmin(xx[k], cc[k])
    s <- s + 1
    if(tt[k] <= yy[k]) k = k+1
  }
 data.frame(list(trun = tt, obs = yy, delta = delta))
}

set.seed(123)
dat <- simDat(50)
B <- 20

## Perform conditional permutation with Kendall's tau, minp1 and minp2
set.seed(123)
system.time(fit <- with(dat, permDep(trun, obs, B, delta, nc = 1)))
fit
}
\references{
Chiou, S.H., Qian, J., and Betensky, R.A. (2017).
Permutation Test for General Dependent Truncation. \emph{Tech-report}
}
\keyword{permDep}
