% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_tfce.R
\name{compute_tfce}
\alias{compute_tfce}
\title{Threshold-Free Cluster-Enhancement correction}
\usage{
compute_tfce(distribution, alternative = "greater", E = 0.5, H = 1, ndh)
}
\arguments{
\item{distribution}{A matrix of permuted statistical signal. The first row indicating the observed statistics.}

\item{alternative}{A character string indicating the alternative hypothesis. Default is \code{"greater"}. Choose between \code{"greater"}, \code{"less"} or \code{"two.sided"}.}

\item{E}{A scalar that represent the extend parameter of the TFCE transformation. Default is \code{E = 0.5}.}

\item{H}{A scalar that represent the height parameter of the TFCE transformation. Default is \code{H = 1}.}

\item{ndh}{The number of terms in the approximation of the integral.}
}
\description{
Compute the TFCE correction given a matrix a permuted statistical signals.
}
\seealso{
Other multcomp: 
\code{\link{compute_clusterdepth_head}()},
\code{\link{compute_clusterdepth}()},
\code{\link{compute_clustermass}()},
\code{\link{compute_maxT}()},
\code{\link{compute_minP}()},
\code{\link{compute_stepdownmaxT}()},
\code{\link{compute_troendle}()}
}
\concept{multcomp}
