% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ConDivSim}
\alias{ConDivSim}
\title{Null models for functional-phylogenetic diversity}
\usage{
ConDivSim(object, type = "traits", n.sim = 100, plot = TRUE,
  disp99 = FALSE)
}
\arguments{
\item{object}{a \code{\link{comparative.comm}} object, with
presence-absence community data.}

\item{type}{character string giving the type of distance matrix on
which the mean pairwise distance is based. Either "trait" or "phy"
to a phylogenetic or trait-based distance matrix, or an actual
matrix to use (e.g., one from \code{\link{funct.phylo.dist}})}

\item{n.sim}{The number of permutations of the presence vector used to
make the estimations.}

\item{plot}{TRUE or FALSE to make the plot of the expected average
mean pairwise distance, and the 5-95\% confidence interval.}

\item{disp99}{Display the 99\% interval?}
}
\value{
TODO
}
\description{
Simulate expectations (under a null model) of mean pairwise distance for
a set of communities with different species richness.
}
\details{
If \code{plot == TRUE}, then a surface is drawn giving the
null distribution.  Lighter shades of gray give larger intervals
with categories: 0.005-0.995 = 99\%, 0.025-0.975 = 95\%, 0.05-0.95
= 90\%, 0.25-0.75 = 50\%.
}
\note{
No serious checking of user-provided matrices is performed;
this is both useful and dangerous!
}
\examples{
data(laja)
data <- comparative.comm(invert.tree, river.sites, invert.traits)
#Must have all species present in at least one community!
#...and must be presence-absence data
data <- data[,colSums(data$comm) > 0]
data$comm[data$comm>1] <- 1
sims <- ConDivSim(data)
#...without traits...
sims.phy <- ConDivSim(data, type="phy")
}
\seealso{
\code{\link{sim.phy}} \code{\link{scape}}
}

