% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.env.regression.R, R/eco.phy.regression.R,
%   R/eco.trait.regression.R, R/utility.R
\name{eco.xxx.regression}
\alias{eco.xxx.regression}
\alias{eco.env.regression}
\alias{eco.phy.regression}
\alias{eco.trait.regression}
\alias{summary.eco.xxx.regression}
\alias{print.eco.xxx.regression}
\alias{plot.eco.xxx.regression}
\title{eco.xxx.regression}
\usage{
eco.env.regression(data, randomisation = c("taxa.labels", "richness",
  "frequency", "sample.pool", "phylogeny.pool", "independentswap",
  "trialswap"), permute = 0, method = c("quantile", "lm", "mantel"),
  altogether = TRUE, indep.swap = 1000, abundance = TRUE, ...)

eco.phy.regression(data, randomisation = c("taxa.labels", "richness",
  "frequency", "sample.pool", "phylogeny.pool", "independentswap",
  "trialswap"), permute = 0, method = c("quantile", "lm", "mantel"),
  indep.swap = 1000, abundance = TRUE, ...)

eco.trait.regression(data, randomisation = c("taxa.labels", "richness",
  "frequency", "sample.pool", "phylogeny.pool", "independentswap",
  "trialswap"), permute = 0, method = c("quantile", "lm", "mantel"),
  altogether = TRUE, indep.swap = 1000, abundance = TRUE, ...)

\method{summary}{eco.xxx.regression}(object, ...)

\method{print}{eco.xxx.regression}(x, ...)

\method{plot}{eco.xxx.regression}(x, ...)
}
\arguments{
\item{data}{\code{\link{comparative.comm}} for analysis}

\item{randomisation}{null distribution with which to compare your
community data, one of: \code{taxa.labels} (DEFAULT),
\code{richness}, \code{frequency}, \code{sample.pool},
\code{phylogeny.pool}, \code{independentswap}, \code{trialswap} (as
implemented in \code{\link{picante}})}

\item{permute}{the number of null permutations to perform (DEFAULT
0)}

\item{method}{how to compare distance matrices (only the lower
triangle;), one of: \code{\link{lm}} (linear regression),
\code{quantile} (DEFAULT; \code{quantreg::\link{rq}}),
\code{mantel} (\code{\link[vegan:mantel]{mantel}})}

\item{altogether}{use distance matrix based on all traits (default
TRUE), or perform separate regressions for each trait (returns a
list, see details)}

\item{indep.swap}{number of independent swap iterations to perform
(if specified in \code{randomisation}; DEFAULT 1000)}

\item{abundance}{whether to incorporate species' abundances
(default: TRUE)}

\item{...}{additional parameters to pass on to model fitting functions}

\item{object}{\code{eco.xxx.regression} object}

\item{x}{\code{eco.xxx.regression} object}
}
\description{
Regression species co-existence against environmental tolerance,
trait similarity, or phylogenetic relatedness.
}
\details{
These methods are similar to those performed in Cavender-Bares et
al. (2004). Each function regresses the species co-existence matrix
of \code{\link{data}} (calculated using \code{\link{comm.dist}})
against either species' trait dissimilarity
(\code{\link{eco.trait.regression}}), species' phylogenetic
distance (\code{\link{eco.phy.regression}}), or species' shared
environmental tolerances as measured by Pianka's distance
(\code{\link{eco.env.regression}}).

If \code{altogether} is set to \code{FALSE}, each trait or
environemntal variables in your data will have a separate
\code{eco.trait.regression} or \code{eco.env.regression} applied to
it. The functions will return a list of individual regressions; you
can either examine/plot them as a group (see examples below), or
extract an individual regression and work with that. These lists
are of class \code{eco.xxx.regression.list}; a bit messy, but it
does work!...
}
\note{
Like \code{\link{fingerprint.regression}}, this is a
data-hungry method. Warnings will be generated if any of the
methods cannot be fitted properly (the examples below give toy
examples of this). In such cases the summary and plot methods of
these functions may generate errors; perhaps use
\code{\link{traceback}} to examine where these are coming from, and
consider whether you want to be working with the data generating
these errors. I am loathe to hide these errors or gloss over them,
because they represent the reality of your data!

WDP loves quantile regressions, and advises that you check
different quantiles using the \code{tau} options.
}
\examples{
data(laja)
#We wouldn't recommend only using ten permutations - this is just for speed!
data <- comparative.comm(invert.tree, river.sites, invert.traits, river.env)
eco.trait.regression(data, permute=10)
#Specify additional options
eco.trait.regression(data, tau=c(0.25,0.5,0.75), permute=10)
plot(eco.trait.regression(data, permute=10, method="lm"))
plot(eco.trait.regression(data, permute=10, method="lm", altogether=FALSE))
}
\references{
Cavender-Bares J., Ackerly D.D., Baum D.A. & Bazzaz F.A. (2004) Phylogenetic overdispersion in Floridian oak communities. The Americant Naturalist 163(6): 823--843.

Kembel, S.W., Cowan, P.D., Helmus, M.R., Cornwell, W.K., Morlon, H., Ackerly, D.D., Blomberg, S.P. & Webb, C.O. Picante: R tools for integrating phylogenies and ecology. Bioinformatics 26(11): 1463--1464.

Pagel M. Inferring the historical patterns of biological evolution. Nature 401(6756): 877--884.
}
\seealso{
\code{\link{fingerprint.regression}} \code{\link{phy.signal}}
}
\author{
Will Pearse, Jeannine Cavender-Bares
}
