% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metapop.sim.R
\name{sim.meta}
\alias{sim.meta}
\alias{sim.meta.comm}
\alias{sim.meta.phy.comm}
\title{Simulate a meta-community (and its phylogeny)}
\usage{
sim.meta.comm(
  size = 10,
  n.spp = 8,
  timesteps = 10,
  p.migrate = 0.05,
  env.lam = 10,
  abund.lam = 5,
  stoch.lam = 1
)

sim.meta.phy.comm(
  size = 10,
  n.spp = 8,
  timesteps = 10,
  p.migrate = 0.3,
  env.lam = 10,
  abund.lam = 5,
  stoch.lam = 1,
  p.speciate = 0.05
)
}
\arguments{
\item{size}{the length and width of the meta-community in grid
cells}

\item{n.spp}{number of species}

\item{timesteps}{number of time-steps (each discrete)}

\item{p.migrate}{probability that a group of species in each grid
cell will migrate to another grid cell each timestep (i.e., 10
cells occuped by a species --> 10*\code{p.migrate} chance of
migration)}

\item{env.lam}{\eqn{$\lambda$}{lambda} value for Poisson
distribution used to distribute environmental quality; essentially
the carrying capacity (for each species separately) for that cell}

\item{abund.lam}{\eqn{$\lambda$}{lambda} value for Poisson
distribution used to distribute initial abundances and abundance
after migration}

\item{stoch.lam}{\eqn{$\lambda$}{lambda} value for Poisson
distribution of noise added to the next step abundance
calculation. With equal chance, this is taken as either a positive
or a negative number (see details if you're confused as to why this
is Poisson!)}

\item{p.speciate}{probabilty that, at each timestep, a species will
speciate. A species can only speciate, migrate, or reproduce if it
has individuals!}
}
\value{
For \code{sim.meta.comm} a list with a species-site matrix
as the first slot, and the environment as the second. Rownames of
the site-species are the List with the x and y co-ordinates of the
simulation grid pasted together; colnames are arbitrary species
names. \code{sim.meta.comm}, a \code{\link{comparative.comm}}
object (since we have now simulated a phylogeny), with the same
naming convention for the site names.  phylogeny.

\code{sim.meta.phy.comm} \code{\link{comparative.comm}}
object that describes the data; note that the rownames of the
community object refer to the \code{row.column} of the data in the
simulated grid assemblages.
}
\description{
\code{sim.meta.comm} simulates species moving through a
metacommunity. At each time-step each cell's next abundance for
each species is \code{env.quality} - \code{current.abundance} +
\code{stochastic}, and a species gets as many chances to migrate in
each time-step as it has cells (the same cell could migrate
multiple times). I use a Poisson for everything because I don't
want half-species (these are individuals), and keeping everything
in Poisson makes it easier to compare the relative rates of
everything.
}
\details{
\code{sim.meta.phy.comm} As above, but with a simulation of
phylogeny as well - there are no additional extinction parameters,
since extinction happens as a natural consequence of ecological
interactions.
}
\note{
\code{\link{scape}} is a much more sophisticated simulation
of the biogeography, but requires you to supply a phylogeny. You
pays your money, you makes your choice.
}
\seealso{
\code{\link{sim.phy}} \code{\link{scape}}
}
\author{
Will Pearse

Will Pearse
}
