% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{flamelet.plot}
\alias{flamelet.plot}
\title{Plot Persistence Flamelet}
\usage{
flamelet.plot(
  flamelet,
  scale.param,
  tseq,
  flat = FALSE,
  scale.name = "Bandwidth",
  band = NULL
)
}
\arguments{
\item{flamelet}{a kxm matrix corresponding to the Persistence Flamelet.}

\item{scale.param}{a vector of lenght m corresponding to the values of the scale parameter at which the Flamelet has been evaluated.}

\item{tseq}{a vector of length k containing of values at which the Flamelet function is evaluated for a fixed scale level.}

\item{flat}{a logical denoting whether the plot should be a 2-d projection of the Flamelet (\code{TRUE}) or a 3-d object (\code{FALSE}).}

\item{scale.name}{name of the scale parameter.}

\item{band}{scalar representing the confidence band for Persistence Flamelet. Only available when \code{flat = FALSE}.}
}
\description{
Plot the Persistence Flamelet in its original 3-dimensional form, or in a 2-dimensional projection.
}
\examples{
\donttest{
library(TDA)
xx = rbind(circleUnif(50, 1), circleUnif(50, 1.5) + 3)
Xlim = c(-1, 5);  Ylim = c(-1, 5);  by = 0.05
lim = cbind(Xlim, Ylim)
foo.flamelet = build.flamelet(X = xx, h.grid = seq(0.01, 1, length.out = 40),
base.type = "landscape", dimension = 1,base.param = 1, lim = lim, by = by,
                            tseq = seq(0, .75, length.out = 500))
flamelet.plot(foo.flamelet, scale.param = seq(0.01, 1, length.out = 40),
             tseq = seq(0, .75, length.out = 500) )


foo.band = flamelet.band(X = xx, B = 10, alpha = 0.05,
                   tseq = seq(0, .75, length.out = 500), diag.fun = kde,
                   h.grid = seq(0.01, 1, length.out = 40), lim = lim, by = by)

flamelet.plot(foo.flamelet, scale.param = seq(0.01, 1, length.out = 40),
             tseq = seq(0, .75, length.out = 500), band = foo.band)
}
}
\references{
T. Padellini and P. Brutti (2017) Persistence Flamelets: multiscale Persistent Homology for kernel density exploration \url{https://arxiv.org/abs/1709.07097}
}
