/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.io.images;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import net.sf.eps2pgf.Main;
import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.io.RandomAccessOutputStream;
import net.sf.eps2pgf.io.images.EpsImageCreator;
import net.sf.eps2pgf.ps.Image;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.resources.colors.PSColor;
import net.sf.eps2pgf.ps.resources.filters.ASCII85Encode;
import net.sf.eps2pgf.ps.resources.filters.FlateEncode;

public final class PdfImageCreator {
    private List<Integer> xrefTable = new ArrayList<Integer>();
    private int xrefOffset;

    public void writeImage(OutputStream outputStream, Image image, String string) throws IOException, PSError, ProgramError {
        RandomAccessOutputStream randomAccessOutputStream = new RandomAccessOutputStream(outputStream);
        randomAccessOutputStream.write("%PDF-1.2\n");
        this.writeCatalog(randomAccessOutputStream);
        this.writeOutlines(randomAccessOutputStream);
        this.writePageTree(randomAccessOutputStream, image);
        this.writeInfoDict(randomAccessOutputStream, string);
        this.writeXrefTable(randomAccessOutputStream);
        this.writeTrailer(randomAccessOutputStream);
        randomAccessOutputStream.close();
    }

    private void writeCatalog(RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        this.xrefTable.add(randomAccessOutputStream.getPointer());
        randomAccessOutputStream.write("1 0 obj\n<<\n");
        randomAccessOutputStream.write("/Type /Catalog\n");
        randomAccessOutputStream.write("/Outlines 2 0 R\n");
        randomAccessOutputStream.write("/Pages 3 0 R\n");
        randomAccessOutputStream.write(">> endobj\n");
    }

    private void writeOutlines(RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        this.xrefTable.add(randomAccessOutputStream.getPointer());
        randomAccessOutputStream.write("2 0 obj\n<<\n/Type /Outlines\n/Count 0\n>>\nendobj\n");
    }

    private void writePageTree(RandomAccessOutputStream randomAccessOutputStream, Image image) throws IOException, PSError, ProgramError {
        this.xrefTable.add(randomAccessOutputStream.getPointer());
        randomAccessOutputStream.write("3 0 obj\n<<\n");
        randomAccessOutputStream.write("/Type /Pages\n");
        randomAccessOutputStream.write("/Kids [4 0 R]\n");
        randomAccessOutputStream.write("/Count 1\n");
        randomAccessOutputStream.write(">>\nendobj\n");
        this.xrefTable.add(randomAccessOutputStream.getPointer());
        randomAccessOutputStream.write("4 0 obj\n<<\n");
        randomAccessOutputStream.write("/Type /Page\n");
        randomAccessOutputStream.write("/Parent 3 0 R\n");
        double d = image.getOutputWidthPt();
        double d2 = image.getOutputHeightPt();
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        randomAccessOutputStream.write("/MediaBox [0.0 0.0 " + decimalFormat.format(d) + " " + decimalFormat.format(d2) + "]\n");
        randomAccessOutputStream.write("/Contents 6 0 R\n");
        randomAccessOutputStream.write("/Resources\n<<\n");
        randomAccessOutputStream.write("/ProcSet [/PDF /ImageB /ImageC /ImageI]\n");
        randomAccessOutputStream.write("/XObject << /Img 5 0 R >>\n");
        randomAccessOutputStream.write(">>\n");
        randomAccessOutputStream.write(">>\nendobj\n");
        this.writeImageXObject(randomAccessOutputStream, image);
        this.xrefTable.add(randomAccessOutputStream.getPointer());
        randomAccessOutputStream.write("6 0 obj\n<<\n");
        randomAccessOutputStream.write("/Length ");
        int n = randomAccessOutputStream.getPointer();
        randomAccessOutputStream.write("          \n");
        randomAccessOutputStream.write(">>\nstream\n");
        int n2 = randomAccessOutputStream.getPointer();
        randomAccessOutputStream.write("q\n");
        randomAccessOutputStream.write(String.format("%.3f 0 0 -%.3f 0 %.3f cm\n", image.getOutputWidthPt(), image.getOutputHeightPt(), image.getOutputHeightPt()));
        randomAccessOutputStream.write("/Img Do\n");
        randomAccessOutputStream.write("Q\n");
        int n3 = randomAccessOutputStream.getPointer();
        randomAccessOutputStream.seek(n);
        randomAccessOutputStream.write(Integer.toString(n3 - n2));
        randomAccessOutputStream.seek(n3);
        randomAccessOutputStream.write("endstream\nendobj\n");
    }

    private void writeImageXObject(RandomAccessOutputStream randomAccessOutputStream, Image image) throws IOException, PSError, ProgramError {
        int n;
        PSColor pSColor = image.getColorSpace();
        this.xrefTable.add(randomAccessOutputStream.getPointer());
        randomAccessOutputStream.write("5 0 obj\n<<\n");
        randomAccessOutputStream.write("/Type /XObject\n");
        randomAccessOutputStream.write("/Subtype /Image\n");
        randomAccessOutputStream.write(String.format("/Width %d\n", image.getOutputWidthPx()));
        randomAccessOutputStream.write(String.format("/Height %d\n", image.getOutputHeightPx()));
        randomAccessOutputStream.write(String.format("/ColorSpace %s\n", pSColor.getColorSpace().isis()));
        randomAccessOutputStream.write(String.format("/BitsPerComponent %d\n", image.getBitsPerComponent()));
        double[] dArray = image.getDecode();
        randomAccessOutputStream.write("/Decode [");
        for (n = 0; n < dArray.length; ++n) {
            if (dArray[n] == (double)Math.round(dArray[n])) {
                randomAccessOutputStream.write(" " + (int)dArray[n]);
                continue;
            }
            randomAccessOutputStream.write(" " + dArray[n]);
        }
        randomAccessOutputStream.write(" ]\n");
        randomAccessOutputStream.write("/Interpolate " + image.getInterpolate() + "\n");
        randomAccessOutputStream.write("/Length ");
        n = randomAccessOutputStream.getPointer();
        randomAccessOutputStream.write("         \n");
        randomAccessOutputStream.write("/Filter [/ASCII85Decode /FlateDecode]\n");
        randomAccessOutputStream.write(">>\nstream\n");
        int n2 = randomAccessOutputStream.getPointer();
        ASCII85Encode aSCII85Encode = new ASCII85Encode(randomAccessOutputStream, null);
        FlateEncode flateEncode = new FlateEncode((OutputStream)aSCII85Encode, null);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(flateEncode);
        EpsImageCreator.writeImageData(bufferedOutputStream, image);
        ((OutputStream)bufferedOutputStream).close();
        ((OutputStream)flateEncode).close();
        ((OutputStream)aSCII85Encode).close();
        int n3 = randomAccessOutputStream.getPointer();
        randomAccessOutputStream.seek(n);
        randomAccessOutputStream.write(String.format("%d", n3 - n2));
        randomAccessOutputStream.seek(n3);
        randomAccessOutputStream.write("endstream\nendobj\n");
    }

    private void writeInfoDict(RandomAccessOutputStream randomAccessOutputStream, String string) throws IOException {
        this.xrefTable.add(randomAccessOutputStream.getPointer());
        randomAccessOutputStream.write("7 0 obj\n<<\n");
        randomAccessOutputStream.write(String.format("/Title (%s)\n", string));
        randomAccessOutputStream.write(String.format("/Producer (%s)\n", Main.getNameVersion()));
        randomAccessOutputStream.write(String.format("/Creator (%s)\n", Main.getNameVersion()));
        Calendar calendar = Calendar.getInstance();
        String string2 = String.format("%04d%02d%02d%02d%02d%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
        int n = calendar.get(15) + calendar.get(16);
        if (n < 0) {
            string2 = string2 + "-";
            n = -n;
        } else {
            string2 = n == 0 ? string2 + "Z" : string2 + "+";
        }
        string2 = string2 + String.format("%02d'%02d'", n / 1000 / 60 / 60, n % 3600000);
        randomAccessOutputStream.write(String.format("/CreationDate (D:%s)\n", string2));
        randomAccessOutputStream.write(">>\nendobj\n");
    }

    private void writeXrefTable(RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        this.xrefOffset = randomAccessOutputStream.getPointer();
        randomAccessOutputStream.write("xref\n");
        randomAccessOutputStream.write("0 " + (this.xrefTable.size() + 1) + "\n");
        randomAccessOutputStream.write("0000000000 65535 f \n");
        for (int i = 0; i < this.xrefTable.size(); ++i) {
            randomAccessOutputStream.write(String.format("%010d %05d n \n", this.xrefTable.get(i), 0));
        }
    }

    private void writeTrailer(RandomAccessOutputStream randomAccessOutputStream) throws IOException {
        randomAccessOutputStream.write("trailer\n<<\n");
        randomAccessOutputStream.write(String.format("/Size %d\n", this.xrefTable.size() + 1));
        randomAccessOutputStream.write("/Root 1 0 R\n");
        randomAccessOutputStream.write("/Info 7 0 R\n");
        UUID uUID = UUID.randomUUID();
        String string = String.format("%8x%8x", uUID.getMostSignificantBits(), uUID.getLeastSignificantBits());
        randomAccessOutputStream.write(String.format("/ID [ <%s> <%s> ]\n", string, string));
        randomAccessOutputStream.write(">>\n");
        randomAccessOutputStream.write("startxref\n");
        randomAccessOutputStream.write(String.format("%d\n", this.xrefOffset));
        randomAccessOutputStream.write("%%EOF");
    }
}

