/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.EnumeratedStringParser;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import java.io.File;

public class Options
extends JSAP {
    private File inputFile;
    private File outputFile;
    private TextMode textMode;
    private OutputType outputType;
    private File textreplacefile;
    private boolean versionFlagSet;
    private boolean helpFlagSet;
    private boolean verboseFlagSet;

    public Options() {
        try {
            FileStringParser fileStringParser = FileStringParser.getParser().setMustExist(true).setMustBeFile(true);
            UnflaggedOption unflaggedOption = new UnflaggedOption("inputfile").setStringParser(fileStringParser).setRequired(true);
            unflaggedOption.setHelp("(Encapsulated) PostScript (EPS or PS) input file.");
            this.registerParameter(unflaggedOption);
            FlaggedOption flaggedOption = new FlaggedOption("outputfilename").setShortFlag('o').setLongFlag("output").setStringParser(JSAP.STRING_PARSER).setDefault("<input file with .pgf extension>").setRequired(true);
            flaggedOption.setHelp("Write output to this file.");
            this.registerParameter(flaggedOption);
            EnumeratedStringParser enumeratedStringParser = EnumeratedStringParser.getParser("exact; directcopy", false, false);
            FlaggedOption flaggedOption2 = new FlaggedOption("textmode").setShortFlag('m').setLongFlag("text-mode").setStringParser(enumeratedStringParser).setDefault("exact");
            flaggedOption2.setHelp("Text label handling. Accepted values: 'exact' (text is reproduced as closely as possible), or 'directcopy' (text is directly copied to the output and scanned for embedded PSfrag text replacement rules).");
            this.registerParameter(flaggedOption2);
            FlaggedOption flaggedOption3 = new FlaggedOption("textreplacefile").setLongFlag("text-replace").setStringParser(fileStringParser).setRequired(false);
            flaggedOption3.setHelp("File containing PSfrag commands describing text replacements.");
            this.registerParameter(flaggedOption3);
            EnumeratedStringParser enumeratedStringParser2 = EnumeratedStringParser.getParser("pgf; lol", false, false);
            FlaggedOption flaggedOption4 = new FlaggedOption("outputtype").setShortFlag('t').setLongFlag("output-type").setStringParser(enumeratedStringParser2).setDefault("pgf");
            flaggedOption4.setHelp("Type of output file. Accepted values: 'pgf' or 'lol'.");
            this.registerParameter(flaggedOption4);
            Switch switch_ = new Switch("verbose").setLongFlag("verbose");
            switch_.setHelp("Display more information during the conversion.");
            this.registerParameter(switch_);
            switch_ = new Switch("version").setLongFlag("version");
            switch_.setHelp("Display version information.");
            this.registerParameter(switch_);
            switch_ = new Switch("help").setLongFlag("help").setShortFlag('h');
            switch_.setHelp("Display program usage.");
            this.registerParameter(switch_);
        }
        catch (JSAPException jSAPException) {
            // empty catch block
        }
    }

    public JSAPResult parse(String[] stringArray) {
        JSAPResult jSAPResult = super.parse(stringArray);
        this.postParse(jSAPResult);
        return jSAPResult;
    }

    private void postParse(JSAPResult jSAPResult) {
        String string;
        this.setInputFile(jSAPResult.getFile("inputfile"));
        if (jSAPResult.getString("outputtype").equals("pgf")) {
            this.setOutputType(OutputType.PGF);
        } else {
            this.setOutputType(OutputType.LOL);
        }
        if (jSAPResult.getString("textmode", "exact").equals("exact")) {
            this.setTextmode(TextMode.EXACT);
        } else {
            this.setTextmode(TextMode.DIRECT_COPY);
        }
        String string2 = jSAPResult.getString("outputfilename").startsWith("<") ? ((string = this.getInputFile().getPath()).toLowerCase().endsWith(".eps") ? string.substring(0, string.length() - 4) + "." + this.getOutputType().toString().toLowerCase() : (string.toLowerCase().endsWith(".ps") ? string.substring(0, string.length() - 3) + "." + this.getOutputType().toString().toLowerCase() : string + "." + this.getOutputType().toString().toLowerCase())) : jSAPResult.getString("outputfilename");
        this.setOutputFile(new File(string2));
        this.setTextreplacefile(jSAPResult.getFile("textreplacefile"));
        this.setHelpFlag(jSAPResult.getBoolean("help"));
        this.setVersionFlag(jSAPResult.getBoolean("version"));
        this.setVerboseFlag(jSAPResult.getBoolean("verbose"));
    }

    public void setTextreplacefile(File file) {
        this.textreplacefile = file;
    }

    public File getTextreplacefile() {
        return this.textreplacefile;
    }

    public void setOutputType(OutputType outputType) {
        this.outputType = outputType;
    }

    public OutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputFile(File file) {
        this.outputFile = file != null ? file : new File("");
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setInputFile(File file) {
        this.inputFile = file != null ? file : new File("");
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setTextmode(TextMode textMode) {
        this.textMode = textMode;
    }

    public TextMode getTextmode() {
        return this.textMode;
    }

    public void setVersionFlag(boolean bl) {
        this.versionFlagSet = bl;
    }

    public boolean isVersionFlagSet() {
        return this.versionFlagSet;
    }

    public void setHelpFlag(boolean bl) {
        this.helpFlagSet = bl;
    }

    public boolean isHelpFlagSet() {
        return this.helpFlagSet;
    }

    public void setVerboseFlag(boolean bl) {
        this.verboseFlagSet = bl;
    }

    public boolean isVerboseFlagSet() {
        return this.verboseFlagSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputType {
        PGF,
        LOL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextMode {
        EXACT,
        DIRECT_COPY;

    }
}

