/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps;

import java.io.IOException;
import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.ps.GstateStack;
import net.sf.eps2pgf.ps.Path;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorNoCurrentPoint;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectFont;
import net.sf.eps2pgf.ps.objects.PSObjectMatrix;
import net.sf.eps2pgf.ps.resources.colors.ColorManager;
import net.sf.eps2pgf.ps.resources.colors.PSColor;
import net.sf.eps2pgf.ps.resources.outputdevices.OutputDevice;

public class GraphicsState
implements Cloneable {
    private PSObjectMatrix ctm = new PSObjectMatrix();
    private double[] position = new double[2];
    private Path path;
    private Path clippingPath;
    private PSColor color;
    private double flat = 1.0;
    private PSObjectFont font;
    private double lineWidth = 1.0;
    private int lineCap = 0;
    private int lineJoin = 0;
    private double miterLimit = 10.0;
    private PSObjectArray dashPattern = new PSObjectArray();
    private double dashOffset = 0.0;
    private boolean strokeAdjust = true;
    private OutputDevice device;

    public GraphicsState(GstateStack gstateStack, OutputDevice outputDevice) {
        this.device = outputDevice;
        this.initmatrix();
        this.path = new Path(gstateStack);
        this.clippingPath = new Path(gstateStack);
        this.font = new PSObjectFont();
    }

    public void arc(double d, double d2, double d3, double d4, double d5, boolean bl) throws PSErrorRangeCheck, PSErrorTypeCheck {
        double d6 = d4;
        double d7 = d5;
        double d8 = 1.0;
        if (!bl) {
            d8 = -1.0;
        }
        while (d8 * d7 < d8 * d6) {
            d7 += d8 * 360.0;
        }
        d6 = Math.toRadians(d6);
        d7 = Math.toRadians(d7);
        double d9 = d + d3 * Math.cos(d6);
        double d10 = d2 + d3 * Math.sin(d6);
        if (Math.abs(this.position[0] - d9) > 1.0E-6 || Math.abs(this.position[1] - d10) > 1.0E-6) {
            this.lineto(d9, d10);
        } else if (Double.isNaN(this.position[0]) || Double.isNaN(this.position[1])) {
            this.moveto(d9, d10);
        }
        double d11 = d6;
        double d12 = d8 * Math.PI / 2.0;
        double d13 = d6;
        while (d8 * d11 < d8 * d7) {
            double d14 = d11;
            d11 = d12 * Math.floor((d13 + d12) / d12);
            if (d8 * d7 < d8 * d11) {
                d11 = d7;
            }
            double d15 = (d14 + d11) / 2.0;
            double d16 = Math.cos(d8 * (d11 - d14) / 2.0);
            double d17 = Math.sin(d8 * (d11 - d14) / 2.0);
            double d18 = (4.0 - d16) / 3.0;
            double d19 = (1.0 - d16) * (3.0 - d16) / (3.0 * d17);
            double d20 = Math.atan2(d19, d18);
            double d21 = Math.sqrt(d18 * d18 + d19 * d19);
            double d22 = d + d3 * d21 * Math.cos(d15 - d8 * d20);
            double d23 = d2 + d3 * d21 * Math.sin(d15 - d8 * d20);
            double d24 = d + d3 * d21 * Math.cos(d15 + d8 * d20);
            double d25 = d2 + d3 * d21 * Math.sin(d15 + d8 * d20);
            double d26 = d + d3 * Math.cos(d11);
            double d27 = d2 + d3 * Math.sin(d11);
            this.curveto(d22, d23, d24, d25, d26, d27);
            d13 += d12;
        }
    }

    public double[] arcto(double d, double d2, double d3, double d4, double d5) throws PSError {
        double d6 = this.position[0];
        double d7 = this.position[1];
        if (Double.isNaN(d6) || Double.isNaN(d7)) {
            throw new PSErrorNoCurrentPoint();
        }
        double d8 = Math.atan2(d7 - d2, d6 - d);
        double d9 = Math.atan2(d4 - d2, d3 - d);
        double d10 = d9 - d8;
        if (d10 > Math.PI) {
            d10 -= Math.PI * 2;
        } else if (d10 < -Math.PI) {
            d10 += Math.PI * 2;
        }
        if (Math.abs(Math.abs(d10) - Math.PI) < 0.001 || Math.abs(d10) < 0.001) {
            this.lineto(d, d2);
            double[] dArray = new double[]{d, d2, d, d2};
            return dArray;
        }
        double d11 = d10 >= 0.0 ? 1.0 : -1.0;
        double d12 = d6 + d5 * Math.cos(d8 + d11 * Math.PI / 2.0);
        double d13 = d7 + d5 * Math.sin(d8 + d11 * Math.PI / 2.0);
        double d14 = d + d5 * Math.cos(d8 + d11 * Math.PI / 2.0);
        double d15 = d2 + d5 * Math.sin(d8 + d11 * Math.PI / 2.0);
        double d16 = d + d5 * Math.cos(d9 - d11 * Math.PI / 2.0);
        double d17 = d2 + d5 * Math.sin(d9 - d11 * Math.PI / 2.0);
        double d18 = d3 + d5 * Math.cos(d9 - d11 * Math.PI / 2.0);
        double d19 = d4 + d5 * Math.sin(d9 - d11 * Math.PI / 2.0);
        double d20 = this.det(this.det(d12, d13, d14, d15), d12 - d14, this.det(d16, d17, d18, d19), d16 - d18);
        double d21 = this.det(d12 - d14, d13 - d15, d16 - d18, d17 - d19);
        double d22 = d20 / d21;
        d20 = this.det(this.det(d12, d13, d14, d15), d13 - d15, this.det(d16, d17, d18, d19), d17 - d19);
        double d23 = d20 / d21;
        double d24 = Math.PI + d8 + d11 * Math.PI / 2.0;
        double d25 = Math.PI + d9 - d11 * Math.PI / 2.0;
        double d26 = d22 + d5 * Math.cos(d24);
        double d27 = d23 + d5 * Math.sin(d24);
        double d28 = d22 + d5 * Math.cos(d25);
        double d29 = d23 + d5 * Math.sin(d25);
        this.arc(d22, d23, d5, d24, d25, d25 > d24);
        double[] dArray = new double[]{d26, d27, d28, d29};
        return dArray;
    }

    public void clip() {
        this.clippingPath = this.path.clone();
    }

    public GraphicsState clone() throws CloneNotSupportedException {
        GraphicsState graphicsState = (GraphicsState)super.clone();
        graphicsState.clippingPath = this.clippingPath.clone();
        graphicsState.color = this.color.clone();
        graphicsState.ctm = this.ctm.clone();
        graphicsState.dashPattern = this.dashPattern.clone();
        graphicsState.device = this.device.clone();
        graphicsState.font = this.font.clone();
        graphicsState.path = this.path.clone();
        graphicsState.position = (double[])this.position.clone();
        return graphicsState;
    }

    public double[] currentcmykcolor() throws PSError, ProgramError {
        return this.color.getCMYK();
    }

    public double currentgray() throws PSError, ProgramError {
        return this.color.getGray();
    }

    public double[] currenthsbcolor() throws PSError, ProgramError {
        return this.color.getHSB();
    }

    public double[] currentrgbcolor() throws PSError, ProgramError {
        return this.color.getRGB();
    }

    public void curveto(double d, double d2, double d3, double d4, double d5, double d6) throws PSErrorRangeCheck, PSErrorTypeCheck {
        this.position[0] = d5;
        this.position[1] = d6;
        double[] dArray = this.ctm.transform(d, d2);
        double[] dArray2 = this.ctm.transform(d3, d4);
        double[] dArray3 = this.ctm.transform(d5, d6);
        this.path.curveto(dArray, dArray2, dArray3);
    }

    double det(double d, double d2, double d3, double d4) {
        return d * d4 - d2 * d3;
    }

    public void flattenpath() throws PSError, ProgramError {
        double d = this.device.defaultCTM().getMeanScaling();
        double d2 = this.flat * 72.0 / 1200.0 * d;
        this.path = this.path.flattenpath(d2);
    }

    public double[] getCurrentPosInDeviceSpace() throws PSErrorNoCurrentPoint {
        if (this.path.getSections().size() == 0) {
            throw new PSErrorNoCurrentPoint();
        }
        return this.path.getSections().get(this.path.getSections().size() - 1).deviceCoor();
    }

    public double getMeanUserScaling() {
        double d = Double.NaN;
        try {
            d = this.ctm.getMeanScaling() / this.device.defaultCTM().getMeanScaling();
        }
        catch (PSErrorRangeCheck pSErrorRangeCheck) {
        }
        catch (PSErrorTypeCheck pSErrorTypeCheck) {
            // empty catch block
        }
        return d;
    }

    public void initmatrix() {
        this.ctm = this.device.defaultCTM();
    }

    public void lineto(double d, double d2) throws PSErrorRangeCheck, PSErrorTypeCheck {
        this.position[0] = d;
        this.position[1] = d2;
        double[] dArray = this.ctm.transform(d, d2);
        this.path.lineto(dArray[0], dArray[1]);
    }

    public void moveto(double d, double d2) throws PSErrorRangeCheck, PSErrorTypeCheck {
        this.position[0] = d;
        this.position[1] = d2;
        double[] dArray = this.ctm.transform(d, d2);
        this.path.moveto(dArray[0], dArray[1]);
    }

    public double[] pathbbox() throws PSError {
        double[] dArray = this.path.boundingBox();
        double[] dArray2 = this.ctm.itransform(dArray[0], dArray[1]);
        double[] dArray3 = this.ctm.itransform(dArray[2], dArray[1]);
        double[] dArray4 = this.ctm.itransform(dArray[2], dArray[3]);
        double[] dArray5 = this.ctm.itransform(dArray[0], dArray[3]);
        double[] dArray6 = new double[]{Math.min(Math.min(dArray2[0], dArray3[0]), Math.min(dArray4[0], dArray5[0])), Math.min(Math.min(dArray2[1], dArray3[1]), Math.min(dArray4[1], dArray5[1])), Math.max(Math.max(dArray2[0], dArray3[0]), Math.max(dArray4[0], dArray5[0])), Math.max(Math.max(dArray2[1], dArray3[1]), Math.max(dArray4[1], dArray5[1]))};
        return dArray6;
    }

    public void rcurveto(double d, double d2, double d3, double d4, double d5, double d6) throws PSErrorRangeCheck, PSErrorTypeCheck {
        double[] dArray = this.ctm.transform(this.position[0] + d, this.position[1] + d2);
        double[] dArray2 = this.ctm.transform(this.position[0] + d3, this.position[1] + d4);
        double[] dArray3 = this.ctm.transform(this.position[0] + d5, this.position[1] + d6);
        this.position[0] = this.position[0] + d5;
        this.position[1] = this.position[1] + d6;
        this.path.curveto(dArray, dArray2, dArray3);
    }

    public void rlineto(double d, double d2) throws PSError {
        if (Double.isNaN(this.position[0])) {
            throw new PSErrorNoCurrentPoint();
        }
        this.position[0] = this.position[0] + d;
        this.position[1] = this.position[1] + d2;
        double[] dArray = this.ctm.transform(this.position);
        this.path.lineto(dArray[0], dArray[1]);
    }

    public void rmoveto(double d, double d2) throws PSError {
        if (Double.isNaN(this.position[0])) {
            throw new PSErrorNoCurrentPoint();
        }
        this.position[0] = this.position[0] + d;
        this.position[1] = this.position[1] + d2;
        double[] dArray = this.ctm.transform(this.position);
        this.path.moveto(dArray[0], dArray[1]);
    }

    public void setcolor(double[] dArray) throws IOException, PSError, ProgramError {
        this.color.setColor(dArray);
    }

    public void setcolorspace(PSObject pSObject) throws PSError, IOException, ProgramError {
        this.color = ColorManager.autoSetColorSpace(pSObject);
    }

    public void updatePosition() throws PSErrorRangeCheck, PSErrorTypeCheck {
        try {
            double[] dArray = this.getCurrentPosInDeviceSpace();
            this.position = this.ctm.itransform(dArray);
        }
        catch (PSErrorNoCurrentPoint pSErrorNoCurrentPoint) {
            this.position[0] = Double.NaN;
            this.position[1] = Double.NaN;
        }
    }

    public void setCtm(PSObjectMatrix pSObjectMatrix) {
        this.ctm = pSObjectMatrix;
    }

    public PSObjectMatrix getCtm() {
        return this.ctm;
    }

    public void setPosition(double d, double d2) {
        this.position[0] = d;
        this.position[1] = d2;
    }

    public double[] getPosition() {
        return (double[])this.position.clone();
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public Path getPath() {
        return this.path;
    }

    public void setClippingPath(Path path) {
        this.clippingPath = path;
    }

    public Path getClippingPath() {
        return this.clippingPath;
    }

    public void setColor(PSColor pSColor) {
        this.color = pSColor;
    }

    public PSColor getColor() {
        return this.color;
    }

    public void setFlat(double d) {
        this.flat = d;
    }

    public double getFlat() {
        return this.flat;
    }

    public void setFont(PSObjectFont pSObjectFont) {
        this.font = pSObjectFont;
    }

    public PSObjectFont getFont() {
        return this.font;
    }

    public void setLineWidth(double d) {
        this.lineWidth = d;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setDashPattern(PSObjectArray pSObjectArray) {
        this.dashPattern = pSObjectArray;
    }

    public PSObjectArray getDashPattern() {
        return this.dashPattern;
    }

    public void setDashOffset(double d) {
        this.dashOffset = d;
    }

    public double getDashOffset() {
        return this.dashOffset;
    }

    public void setDevice(OutputDevice outputDevice) {
        this.device = outputDevice;
    }

    public OutputDevice getDevice() {
        return this.device;
    }

    public void setLineCap(int n) {
        this.lineCap = n;
    }

    public int getLineCap() {
        return this.lineCap;
    }

    public void setLineJoin(int n) {
        this.lineJoin = n;
    }

    public int getLineJoin() {
        return this.lineJoin;
    }

    public void setMiterLimit(double d) {
        this.miterLimit = d;
    }

    public double getMiterLimit() {
        return this.miterLimit;
    }

    public void setStrokeAdjust(boolean bl) {
        this.strokeAdjust = bl;
    }

    public boolean getStrokeAdjust() {
        return this.strokeAdjust;
    }
}

