/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.objects;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.io.PSStringInputStream;
import net.sf.eps2pgf.io.StringInputStream;
import net.sf.eps2pgf.ps.Parser;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorIOError;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectBool;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.objects.PSObjectInt;
import net.sf.eps2pgf.ps.objects.PSObjectName;
import net.sf.eps2pgf.ps.objects.PSObjectReal;
import net.sf.eps2pgf.ps.resources.filters.ASCII85Decode;
import net.sf.eps2pgf.ps.resources.filters.ASCIIHexDecode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSObjectString
extends PSObject {
    private StringBuilder value;
    private int offset;
    private int count;

    public PSObjectString(int n) throws PSErrorRangeCheck {
        if (n < 0) {
            throw new PSErrorRangeCheck();
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("\u0000");
        }
        this.value = new StringBuilder(stringBuilder.toString());
        this.offset = 0;
        this.count = this.value.length();
    }

    public PSObjectString(String string) {
        this.value = new StringBuilder(string);
        this.offset = 0;
        this.count = this.value.length();
    }

    public PSObjectString(String string, boolean bl) throws PSError {
        String string2 = string;
        if (bl) {
            int n = string2.length();
            if (n > 0 && string2.charAt(0) == '(' && string2.charAt(n - 1) == ')') {
                string2 = this.parse(string2.substring(1, n - 1));
            } else if (n > 0 && string2.substring(0, 2).equals("<~") && string2.substring(n - 2).equals("~>")) {
                string2 = this.parseBase85(string2.substring(2, n - 2));
            } else if (n > 0 && string2.charAt(0) == '<' && string2.charAt(n - 1) == '>') {
                string2 = this.parseHex(string2.substring(1, n - 1));
            }
        }
        this.value = new StringBuilder(string2);
        this.offset = 0;
        this.count = this.value.length();
    }

    public PSObjectString(PSObjectString pSObjectString, int n, int n2) throws PSErrorRangeCheck {
        if (n < 0 || n2 < 0) {
            throw new PSErrorRangeCheck();
        }
        if (n + n2 > pSObjectString.count) {
            throw new PSErrorRangeCheck();
        }
        this.value = pSObjectString.value;
        this.offset = n + pSObjectString.offset;
        this.count = n2;
        this.copyCommonAttributes(pSObjectString);
    }

    public List<PSObject> anchorsearch(String string) {
        String string2 = this.toString();
        int n = string2.length();
        int n2 = string.length();
        LinkedList<PSObject> linkedList = new LinkedList<PSObject>();
        if (!string2.startsWith(string)) {
            linkedList.add(this);
            linkedList.add(new PSObjectBool(false));
        } else {
            try {
                linkedList.add(this.getinterval(n2, n - n2));
                linkedList.add(this.getinterval(0, n2));
            }
            catch (PSErrorRangeCheck pSErrorRangeCheck) {
                // empty catch block
            }
            linkedList.add(new PSObjectBool(true));
        }
        return linkedList;
    }

    @Override
    public PSObjectString clone() {
        PSObjectString pSObjectString = (PSObjectString)super.clone();
        pSObjectString.value = new StringBuilder(this.value);
        return pSObjectString;
    }

    @Override
    public PSObject copy(PSObject pSObject) throws PSErrorRangeCheck, PSErrorTypeCheck {
        String string = pSObject.toPSString().toString();
        this.putinterval(0, string);
        return this.getinterval(0, string.length());
    }

    @Override
    public int cvi() throws PSError {
        PSObjectReal pSObjectReal = new PSObjectReal(this.value.toString());
        return pSObjectReal.cvi();
    }

    public PSObjectName cvn() {
        return new PSObjectName(this.value.toString(), this.isLiteral());
    }

    @Override
    public double cvr() throws PSError {
        PSObjectReal pSObjectReal = new PSObjectReal(this.value.toString());
        return pSObjectReal.toReal();
    }

    @Override
    public String cvs() {
        return this.toString();
    }

    public PSObjectArray decode(PSObjectArray pSObjectArray) throws PSErrorRangeCheck {
        PSObjectArray pSObjectArray2 = new PSObjectArray();
        for (int i = 0; i < this.count; ++i) {
            int n = this.get(i);
            pSObjectArray2.addAt(i, pSObjectArray.get(n));
        }
        return pSObjectArray2;
    }

    @Override
    public PSObjectString dup() {
        try {
            return new PSObjectString(this, 0, this.count);
        }
        catch (PSErrorRangeCheck pSErrorRangeCheck) {
            return null;
        }
    }

    @Override
    public boolean eq(PSObject pSObject) {
        if (pSObject instanceof PSObjectName) {
            PSObjectName pSObjectName = (PSObjectName)pSObject;
            return this.toString().equals(pSObjectName.toString());
        }
        if (pSObject instanceof PSObjectString) {
            PSObjectString pSObjectString = (PSObjectString)pSObject;
            return this.toString().equals(pSObjectString.toString());
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof PSObject) {
            return this.eq((PSObject)object);
        }
        return false;
    }

    public int get(int n) throws PSErrorRangeCheck {
        if (n < 0 || n >= this.count) {
            throw new PSErrorRangeCheck();
        }
        return this.value.charAt(n + this.offset);
    }

    @Override
    public PSObject get(PSObject pSObject) throws PSErrorTypeCheck, PSErrorRangeCheck {
        int n = this.get(pSObject.toInt());
        return new PSObjectInt(n);
    }

    @Override
    public PSObjectString getinterval(int n, int n2) throws PSErrorRangeCheck {
        return new PSObjectString(this, n, n2);
    }

    @Override
    public List<PSObject> getItemList() throws PSErrorTypeCheck {
        LinkedList<PSObject> linkedList = new LinkedList<PSObject>();
        linkedList.add(new PSObjectInt(1));
        for (PSObject pSObject : this) {
            linkedList.add(pSObject);
        }
        return linkedList;
    }

    @Override
    public boolean gt(PSObject pSObject) throws PSErrorTypeCheck {
        String string;
        String string2 = this.value.toString();
        return string2.compareTo(string = pSObject.toPSString().toString()) > 0;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String isis() {
        int n = 0;
        int n2 = 0;
        try {
            for (int i = 0; i < this.length(); ++i) {
                int n3 = this.get(i);
                if (n3 >= 32 && n3 <= 127) {
                    ++n;
                    continue;
                }
                ++n2;
            }
        }
        catch (PSErrorRangeCheck pSErrorRangeCheck) {
            // empty catch block
        }
        if (n2 > 5 && 2 * n2 >= n) {
            return this.isisHex();
        }
        return this.isisNormal();
    }

    private String isisNormal() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.toString();
        stringBuilder.append('(');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '(') {
                stringBuilder.append("\\(");
                continue;
            }
            if (c == ')') {
                stringBuilder.append("\\)");
                continue;
            }
            if (c == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (c >= ' ' && c <= '~') {
                stringBuilder.append(c);
                continue;
            }
            if (c == '\r') {
                stringBuilder.append("\\r");
                continue;
            }
            if (c == '\n') {
                stringBuilder.append("\\n");
                continue;
            }
            if (c == '\t') {
                stringBuilder.append("\\t");
                continue;
            }
            if (c == '\b') {
                stringBuilder.append("\\b");
                continue;
            }
            if (c == '\f') {
                stringBuilder.append("\\f");
                continue;
            }
            stringBuilder.append('\\');
            stringBuilder.append(Integer.toOctalString(c));
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private String isisHex() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.toString();
        stringBuilder.append("<\n");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuilder.append(String.format("%02x", c));
            if (i % 40 != 39) continue;
            stringBuilder.append('\n');
        }
        stringBuilder.append("\n>");
        return stringBuilder.toString();
    }

    public static boolean isType(String string) {
        int n = string.length();
        if (n >= 2 && string.charAt(0) == '(' && string.charAt(n - 1) == ')') {
            return true;
        }
        if (n >= 4 && string.substring(0, 2).equals("<~") && string.substring(n - 2).equals("~>")) {
            return true;
        }
        return n >= 2 && string.charAt(0) == '<' && string.charAt(n - 1) == '>';
    }

    @Override
    public int length() {
        return this.count;
    }

    public void overwrite(String string) throws PSErrorRangeCheck {
        this.putinterval(0, string);
        this.count = string.length();
    }

    public String parse(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\\') {
                stringBuilder.append(c);
                continue;
            }
            Pattern pattern = Pattern.compile("\\\\[0-7]{1,3}");
            Matcher matcher = pattern.matcher(string);
            if (matcher.find(i) && matcher.start() == i) {
                c = (char)Integer.parseInt(matcher.group().substring(1), 8);
                stringBuilder.append(c);
                i = i + matcher.end() - matcher.start() - 1;
                continue;
            }
            pattern = Pattern.compile("\\\\[\r\n]{1,2}");
            matcher = pattern.matcher(string);
            if (matcher.find(i) && matcher.start() == i) {
                i = i + matcher.end() - matcher.start() - 1;
                continue;
            }
            if (string.charAt(++i) == 'n') {
                stringBuilder.append('\n');
                continue;
            }
            if (string.charAt(i) == 'r') {
                stringBuilder.append('\r');
                continue;
            }
            if (string.charAt(i) == 't') {
                stringBuilder.append('\t');
                continue;
            }
            if (string.charAt(i) == 'b') {
                stringBuilder.append('\b');
                continue;
            }
            if (string.charAt(i) == 'f') {
                stringBuilder.append('\f');
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    public String parseBase85(String string) throws PSError {
        StringInputStream stringInputStream = new StringInputStream(string);
        PSObjectDict pSObjectDict = new PSObjectDict();
        ASCII85Decode aSCII85Decode = new ASCII85Decode(stringInputStream, pSObjectDict);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = ((InputStream)aSCII85Decode).read()) != -1) {
                stringBuilder.append((char)n);
            }
        }
        catch (IOException iOException) {
            throw new PSErrorIOError();
        }
        return stringBuilder.toString();
    }

    public String parseHex(String string) throws PSError {
        StringInputStream stringInputStream = new StringInputStream(string);
        PSObjectDict pSObjectDict = new PSObjectDict();
        ASCIIHexDecode aSCIIHexDecode = new ASCIIHexDecode(stringInputStream, pSObjectDict);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = ((InputStream)aSCIIHexDecode).read()) != -1) {
                stringBuilder.append((char)n);
            }
        }
        catch (IOException iOException) {
            throw new PSErrorIOError();
        }
        return stringBuilder.toString();
    }

    @Override
    public void put(PSObject pSObject, PSObject pSObject2) throws PSErrorRangeCheck, PSErrorTypeCheck {
        int n = pSObject.toInt();
        if (n < 0 || n >= this.count) {
            throw new PSErrorRangeCheck();
        }
        int n2 = pSObject2.toNonNegInt();
        if (n2 > 255) {
            throw new PSErrorRangeCheck();
        }
        char c = (char)n2;
        this.value.setCharAt(n, c);
    }

    public void putinterval(int n, String string) throws PSErrorRangeCheck {
        if (n < 0 || string.length() > this.count - n) {
            throw new PSErrorRangeCheck();
        }
        this.value.replace(this.offset + n, this.offset + n + string.length(), string);
    }

    @Override
    public void putinterval(int n, PSObject pSObject) throws PSErrorTypeCheck, PSErrorRangeCheck {
        String string = pSObject.toPSString().toString();
        this.putinterval(n, string);
    }

    public List<PSObject> search(String string) {
        String string2 = this.toString();
        int n = string2.length();
        int n2 = string.length();
        LinkedList<PSObject> linkedList = new LinkedList<PSObject>();
        int n3 = string2.indexOf(string);
        if (n3 == -1) {
            linkedList.add(this);
            linkedList.add(new PSObjectBool(false));
        } else {
            try {
                linkedList.add(this.getinterval(n3 + n2, n - n3 - n2));
                linkedList.add(this.getinterval(n3, n2));
                linkedList.add(this.getinterval(0, n3));
            }
            catch (PSErrorRangeCheck pSErrorRangeCheck) {
                // empty catch block
            }
            linkedList.add(new PSObjectBool(true));
        }
        return linkedList;
    }

    public void set(int n, char c) throws PSErrorRangeCheck {
        if (n < 0 || n >= this.count) {
            throw new PSErrorRangeCheck();
        }
        this.value.setCharAt(n + this.offset, c);
    }

    @Override
    public PSObjectString toPSString() {
        return this;
    }

    public String toString() {
        return this.value.substring(this.offset, this.offset + this.count);
    }

    @Override
    public List<PSObject> token() throws PSError, ProgramError {
        PSObject pSObject;
        PSStringInputStream pSStringInputStream = new PSStringInputStream(this);
        try {
            pSObject = Parser.convertSingle(pSStringInputStream);
        }
        catch (IOException iOException) {
            pSObject = null;
        }
        ArrayList<PSObject> arrayList = new ArrayList<PSObject>();
        if (pSObject != null) {
            PSObjectString pSObjectString;
            int n = Parser.getCharsLastConvert();
            try {
                pSObjectString = this.getinterval(n, this.count - n);
            }
            catch (PSErrorRangeCheck pSErrorRangeCheck) {
                pSObjectString = new PSObjectString("");
            }
            arrayList.add(pSObjectString);
            arrayList.add(pSObject);
            arrayList.add(new PSObjectBool(true));
        } else {
            arrayList.add(new PSObjectBool(false));
        }
        return arrayList;
    }

    @Override
    public String type() {
        return "stringtype";
    }

    public int numstringLength() throws PSError {
        if (this.get(0) != 149) {
            throw new PSErrorTypeCheck();
        }
        int n = this.get(1);
        int n2 = n < 128 ? this.get(2) << 8 | this.get(3) : this.get(3) << 8 | this.get(2);
        return n2;
    }

    public double numstringGet(int n) throws PSError {
        double d;
        boolean bl;
        if (this.get(0) != 149) {
            throw new PSErrorTypeCheck();
        }
        int n2 = this.get(1);
        if (n2 < 128) {
            bl = true;
        } else {
            bl = false;
            n2 -= 128;
        }
        if (n2 < 32) {
            int n3 = bl ? this.get(4 * n + 4) << 24 | this.get(4 * n + 5) << 16 | this.get(4 * n + 6) << 8 | this.get(4 * n + 7) : this.get(4 * n + 7) << 24 | this.get(4 * n + 6) << 16 | this.get(4 * n + 5) << 8 | this.get(4 * n + 4);
            d = (double)n3 / Math.pow(2.0, n2);
        } else if (n2 < 48) {
            short s = bl ? (short)((short)(this.get(2 * n + 4) << 8) | this.get(2 * n + 5)) : (short)((short)(this.get(2 * n + 5) << 8) | this.get(2 * n + 4));
            d = (double)s / Math.pow(2.0, (double)n2 - 32.0);
        } else if (n2 < 50) {
            int n4 = bl ? this.get(4 * n + 4) << 24 | this.get(4 * n + 5) << 16 | this.get(4 * n + 6) << 8 | this.get(4 * n + 7) : this.get(4 * n + 7) << 24 | this.get(4 * n + 6) << 16 | this.get(4 * n + 5) << 8 | this.get(4 * n + 4);
            d = Float.intBitsToFloat(n4);
        } else {
            throw new PSErrorTypeCheck();
        }
        return d;
    }
}

