% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projcore.R
\name{projcore}
\alias{projcore}
\title{Calculate the residual of a matrix projected on a factor matrix}
\usage{
projcore(x, b, method = c("lasso", "sam"))
}
\arguments{
\item{x}{matrix}

\item{b}{factor matrix}

\item{method}{projection method. Default = 'linear'.}
}
\value{
a residual matrix
\item{resi}{a residual matrix}
}
\description{
\code{projcore} calculates the residual of a matrix projected on a factor matrix using a method
specified.
}
\examples{
library(splines)
K = 3
n = 100
b = matrix(rnorm(K*n),n,K)
bx = 1:3
by = c(1,2,2)
x = b\%*\%bx+rnorm(n)
y = b\%*\%by+rnorm(n)
fit1 = projcore(x, b, method = "lasso")
fit2 = projcore(y, b, method = "sam")
}
\seealso{
\code{\link{greg}}, \code{\link{roc}}, \code{\link{projcov}}, \code{\link{pgraph}}
}

