% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguRegressor.R
\name{pgu.regressor}
\alias{pgu.regressor}
\title{pgu.regressor}
\format{
\link[R6:R6Class]{R6::R6Class} object.
}
\description{
A class that performs pairwise robust regression on the pguIMP data set.
}
\details{
A class that performs pairwise robust regression on the pguIMP data set.
This object is used by the shiny based gui and is not for use in individual R-scripts!
}
\author{
Sebastian Malkusch, \email{malkusch@med.uni-frankfurt.de}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{featureNames}}{Returns the instance variable featureNames.
(character)}

\item{\code{setFeatureNames}}{Sets the instance variable featureNames.
It further initializes the instance variables:
intercept, pIntercept, slope, pSlope.
(character)}

\item{\code{intercept}}{Returns the instance variable intercept.
(matrix)}

\item{\code{pIntercept}}{Returns instance variable pIntercept.
(matrix)}

\item{\code{slope}}{Returns the instance variable slope.
(matrix)}

\item{\code{pSlope}}{Returns the instance variable pSlope.
(matrix)}

\item{\code{model}}{Returns the instance variable model.
(robust::lmRob)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{pgu.regressor$new()}}
\item \href{#method-finalize}{\code{pgu.regressor$finalize()}}
\item \href{#method-print}{\code{pgu.regressor$print()}}
\item \href{#method-resetRegressor}{\code{pgu.regressor$resetRegressor()}}
\item \href{#method-resetDiagonal}{\code{pgu.regressor$resetDiagonal()}}
\item \href{#method-resetMatrix}{\code{pgu.regressor$resetMatrix()}}
\item \href{#method-featureIdx}{\code{pgu.regressor$featureIdx()}}
\item \href{#method-featureIsValid}{\code{pgu.regressor$featureIsValid()}}
\item \href{#method-featurePairIsValid}{\code{pgu.regressor$featurePairIsValid()}}
\item \href{#method-createModel}{\code{pgu.regressor$createModel()}}
\item \href{#method-createRegressionMatrix}{\code{pgu.regressor$createRegressionMatrix()}}
\item \href{#method-printModel}{\code{pgu.regressor$printModel()}}
\item \href{#method-printInterceptTbl}{\code{pgu.regressor$printInterceptTbl()}}
\item \href{#method-printPInterceptTbl}{\code{pgu.regressor$printPInterceptTbl()}}
\item \href{#method-printSlopeTbl}{\code{pgu.regressor$printSlopeTbl()}}
\item \href{#method-printPSlopeTbl}{\code{pgu.regressor$printPSlopeTbl()}}
\item \href{#method-plotRegression}{\code{pgu.regressor$plotRegression()}}
\item \href{#method-plotResidualDist}{\code{pgu.regressor$plotResidualDist()}}
\item \href{#method-plotResidualBox}{\code{pgu.regressor$plotResidualBox()}}
\item \href{#method-plotModel}{\code{pgu.regressor$plotModel()}}
\item \href{#method-clone}{\code{pgu.regressor$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates and returns a new \code{pgu.regressor} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$new(data = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be modeled.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{pgu.regressor} object.
(pguIMP::pgu.regressor)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-finalize}{}}}
\subsection{Method \code{finalize()}}{
Clears the heap and
indicates if instance of \code{pgu.regressor} is removed from heap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a \code{pgu.regressor} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resetRegressor"></a>}}
\if{latex}{\out{\hypertarget{method-resetRegressor}{}}}
\subsection{Method \code{resetRegressor()}}{
Performes pair-wise robust linear regression on the attributes of the data tibble.
Progresse is indicated by the progress object passed to the function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$resetRegressor(data = "tbl_df", progress = "Progress")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{Dataframe with at least two numeric attributes.
(tibble::tibble)}

\item{\code{progress}}{Keeps track of the analysis progress.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resetDiagonal"></a>}}
\if{latex}{\out{\hypertarget{method-resetDiagonal}{}}}
\subsection{Method \code{resetDiagonal()}}{
Sets the diagonal of a square matrix to NA.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$resetDiagonal(data = "matrix")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The matrix whose diagonal is to be reset.
(matrix)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A matrix with its diagonal reset to NA.
(matrix)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resetMatrix"></a>}}
\if{latex}{\out{\hypertarget{method-resetMatrix}{}}}
\subsection{Method \code{resetMatrix()}}{
Creates a square matrix which dimension corresponds to the length
of the instance variable featureNames. The matrix entries are set to a distict \code{value}.
The diagonal is set to NA.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$resetMatrix(value = "numeric")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{The value the matrix entries are set to.
(numeric)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A square matrix.
(matrix)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-featureIdx"></a>}}
\if{latex}{\out{\hypertarget{method-featureIdx}{}}}
\subsection{Method \code{featureIdx()}}{
Determines the numerical index of the column of an attribute based on the attribute name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$featureIdx(feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{The attribute's name.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The attributes column index.
(numeric)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-featureIsValid"></a>}}
\if{latex}{\out{\hypertarget{method-featureIsValid}{}}}
\subsection{Method \code{featureIsValid()}}{
Checks if the feature is known to the class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$featureIsValid(feature = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature}}{An attribute's name that is to be checked.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The test result.
(logical)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-featurePairIsValid"></a>}}
\if{latex}{\out{\hypertarget{method-featurePairIsValid}{}}}
\subsection{Method \code{featurePairIsValid()}}{
Checks a if a pair of attributes different and known to the class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$featurePairIsValid(
  abscissa = "character",
  ordinate = "character"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{abscissa}}{An attribute's name that is to be checked.
(character)}

\item{\code{ordinate}}{An attribute's name that is to be checked.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The test result.
(logical)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-createModel"></a>}}
\if{latex}{\out{\hypertarget{method-createModel}{}}}
\subsection{Method \code{createModel()}}{
Creates a robust model of linear regression between two attributes of a dataframe.
The model is stored as instance variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$createModel(
  data = "tbl_df",
  abscissa = "character",
  ordinate = "character"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be modeled.
(tibble::tibble)}

\item{\code{abscissa}}{An attribute's name that equals a column name in the data.
(character)}

\item{\code{ordinate}}{An attribute's name that equals a column name in the data.
(character)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-createRegressionMatrix"></a>}}
\if{latex}{\out{\hypertarget{method-createRegressionMatrix}{}}}
\subsection{Method \code{createRegressionMatrix()}}{
Performs the actual robust linear regression routine.
Iteratively runs through the attributes known to the class
and creates a robust linear regression model for each valid attribute pair.
The model results are stored in the instance variables:
intercept, pIntercept, slope, pSlope.
Here, pX represents the p-value of the respective parameter X.
Displays the progress if shiny is loaded.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$createRegressionMatrix(data = "tbl_df", progress = "Progress")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be modeled.
(tibble::tibble)}

\item{\code{progress}}{If shiny is loaded, the analysis' progress is stored within this instance of the shiny Progress class.
(shiny::Progress)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-printModel"></a>}}
\if{latex}{\out{\hypertarget{method-printModel}{}}}
\subsection{Method \code{printModel()}}{
Transforms the results of the modeling procedure for a valid pair of attributes to a dataframe
and returns it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$printModel(abscissa = "character", ordinate = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{abscissa}}{The name of the attribute which is assigned to the abscissa.
(character)}

\item{\code{ordinate}}{The name of the attribute which is assigned to the ordinate.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The analyis result as a dataframe.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-printInterceptTbl"></a>}}
\if{latex}{\out{\hypertarget{method-printInterceptTbl}{}}}
\subsection{Method \code{printInterceptTbl()}}{
Transfroms instance variable intercept to a dataframe and returns it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$printInterceptTbl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Dataframe of instance variable intercept.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-printPInterceptTbl"></a>}}
\if{latex}{\out{\hypertarget{method-printPInterceptTbl}{}}}
\subsection{Method \code{printPInterceptTbl()}}{
Transfroms instance variable pIntercept to a dataframe and returns it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$printPInterceptTbl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Dataframe of instance variable pIntercept.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-printSlopeTbl"></a>}}
\if{latex}{\out{\hypertarget{method-printSlopeTbl}{}}}
\subsection{Method \code{printSlopeTbl()}}{
Transfroms instance variable slope to a dataframe and returns it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$printSlopeTbl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Dataframe of instance variable slope.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-printPSlopeTbl"></a>}}
\if{latex}{\out{\hypertarget{method-printPSlopeTbl}{}}}
\subsection{Method \code{printPSlopeTbl()}}{
Transfroms instance variable pSlope to a dataframe and returns it.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$printPSlopeTbl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Dataframe of instance variable pSlope.
(tibble::tibble)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotRegression"></a>}}
\if{latex}{\out{\hypertarget{method-plotRegression}{}}}
\subsection{Method \code{plotRegression()}}{
Creates a scatter plot of the model
stored within the instance variable of the class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$plotRegression()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A scatter plot.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotResidualDist"></a>}}
\if{latex}{\out{\hypertarget{method-plotResidualDist}{}}}
\subsection{Method \code{plotResidualDist()}}{
Creates a histogram of the residual distribution of the model
stored within the instance variable of the class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$plotResidualDist()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A histogram plot.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotResidualBox"></a>}}
\if{latex}{\out{\hypertarget{method-plotResidualBox}{}}}
\subsection{Method \code{plotResidualBox()}}{
Creates a box plot of the residual distribution of the model
stored within the instance variable of the class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$plotResidualBox()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A box plot.
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotModel"></a>}}
\if{latex}{\out{\hypertarget{method-plotModel}{}}}
\subsection{Method \code{plotModel()}}{
Creates a model of robust linear regression.
Executes all graphical exploration functions of the class
and creates a composite graph based on their results.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$plotModel(
  data = "tbl_df",
  abscissa = "character",
  ordinate = "character"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data to be modeled.
(tibble::tibble)}

\item{\code{abscissa}}{The name of the attribute which is assigned to the abscissa.
(character)}

\item{\code{ordinate}}{The name of the attribute which is assigned to the ordinate.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A composite graph.
(gridExtra::grid.arrange)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.regressor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
