% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ph2rand_terminal.R
\name{plot.ph2rand_terminal}
\alias{plot.ph2rand_terminal}
\title{Plot the terminal points of a randomised clinical trial design that assumes a
Bernoulli distributed primary outcome variable}
\usage{
\method{plot}{ph2rand_terminal}(x, output = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{ph2rand_terminal}, as returned by
\code{\link{terminal}}.}

\item{output}{A \code{\link{logical}} variable indicating whether outputs
should be returned by the function.}

\item{...}{Not currently used.}
}
\value{
If \code{output = TRUE}, a \code{\link{list}} containing each of the
input parameters along with plot(s) in the slot \code{$plots}, which gives
the produced plot(s) of the terminal points.
}
\description{
\code{plot.ph2rand_terminal} plots the terminal points of a design returned
by \code{\link{terminal}}.
}
\examples{
# The default two-stage design
des  <- des_two_stage()
# Its terminal points across stages 1 and 2
term <- terminal(des)
# The plot of them
plot(term)
# Its terminal points from stage 2 only
term <- terminal(des, 2)
# The plot of them
plot(term)
}
\seealso{
\code{\link{des_one_stage}}, \code{\link{des_two_stage}},
\code{\link{terminal}}, \code{\link{plot.ph2rand_des}}.
}
