% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treedist.R
\name{treedist}
\alias{treedist}
\alias{sprdist}
\alias{SPR.dist}
\alias{RF.dist}
\alias{wRF.dist}
\alias{KF.dist}
\alias{path.dist}
\title{Distances between trees}
\usage{
treedist(tree1, tree2, check.labels = TRUE)

sprdist(tree1, tree2)

SPR.dist(tree1, tree2 = NULL)

RF.dist(tree1, tree2 = NULL, normalize = FALSE, check.labels = TRUE,
  rooted = FALSE)

wRF.dist(tree1, tree2 = NULL, normalize = FALSE, check.labels = TRUE,
  rooted = FALSE)

KF.dist(tree1, tree2 = NULL, check.labels = TRUE, rooted = FALSE)

path.dist(tree1, tree2 = NULL, check.labels = TRUE, use.weight = FALSE)
}
\arguments{
\item{tree1}{A phylogenetic tree (class \code{phylo}) or vector of trees (an
object of class \code{multiPhylo}). See details}

\item{tree2}{A phylogenetic tree.}

\item{check.labels}{compares labels of the trees.}

\item{normalize}{compute normalized RF-distance, see details.}

\item{rooted}{take bipartitions for rooted trees into account, default is
unrooting the trees.}

\item{use.weight}{use edge.length argument or just count number of edges on
the path (default)}
}
\value{
\code{treedist} returns a vector containing the following tree
distance methods \item{symmetric.difference}{symmetric.difference or
Robinson-Foulds distance}
\item{branch.score.difference}{branch.score.difference}
\item{path.difference}{path.difference}
\item{weighted.path.difference}{weighted.path.difference}
}
\description{
\code{treedist} computes different tree distance methods and \code{RF.dist}
the Robinson-Foulds or symmetric distance. The Robinson-Foulds distance only
depends on the toplogy of the trees. If edge weights should be considered
\code{wRF.dist} calculates the weighted RF distance (Robinson & Foulds
1981). and \code{KF.dist} calculates the branch score distance (Kuhner &
Felsenstein 1994).  \code{path.dist} computes the path difference metric as
described in Steel and Penny 1993).
\code{sprdist} computes the approximate SPR distance (Oliveira Martins et
al. 2008, de Oliveira Martins 2016).
}
\details{
The Robinson-Foulds distance between two trees \eqn{T_1} and \eqn{T_2} with
\eqn{n} tips is defined as (following the notation Steel and Penny 1993):
\deqn{d(T_1, T_2) = i(T_1) + i(T_2) - 2v_s(T_1, T_2)} where \eqn{i(T_1)}
denotes the number of internal edges and \eqn{v_s(T_1, T_2)} denotes the
number of internal splits shared by the two trees. The normalized
Robinson-Foulds distance is derived by dividing \eqn{d(T_1, T_2)} by the
maximal possible distance \eqn{i(T_1) + i(T_2)}. If both trees are unrooted
and binary this value is \eqn{2n-6}.

Functions like \code{RF.dist} returns the Robinson-Foulds distance (Robinson
and Foulds 1981) between either 2 trees or computes a matrix of all pairwise
distances if a \code{multiPhylo} object is given.

For large number of trees the distance functions can use a lot of memory!
}
\examples{

tree1 <- rtree(100, rooted=FALSE)
tree2 <- rSPR(tree1, 3)
RF.dist(tree1, tree2)
treedist(tree1, tree2)
sprdist(tree1, tree2)
trees <- rSPR(tree1, 1:5)
SPR.dist(tree1, trees)

}
\references{
de Oliveira Martins L., Leal E., Kishino H. (2008)
\emph{Phylogenetic Detection of Recombination with a Bayesian Prior on the
Distance between Trees}. PLoS ONE \bold{3(7)}. e2651. doi:
10.1371/journal.pone.0002651

de Oliveira Martins L., Mallo D., Posada D. (2016) \emph{A Bayesian
Supertree Model for Genome-Wide Species Tree Reconstruction}. Syst. Biol.
\bold{65(3)}: 397-416, doi:10.1093/sysbio/syu082

Steel M. A. and Penny P. (1993) \emph{Distributions of tree comparison
metrics - some new results}, Syst. Biol., \bold{42(2)}, 126--141

Kuhner, M. K. and Felsenstein, J. (1994) \emph{A simulation comparison of
phylogeny algorithms under equal and unequal evolutionary rates}, Molecular
Biology and Evolution, \bold{11(3)}, 459--468

D.F. Robinson and L.R. Foulds (1981) \emph{Comparison of phylogenetic
trees}, Mathematical Biosciences, \bold{53(1)}, 131--147

D.F. Robinson and L.R. Foulds (1979) Comparison of weighted labelled trees.
In Horadam, A. F. and Wallis, W. D. (Eds.), \emph{Combinatorial Mathematics
VI: Proceedings of the Sixth Australian Conference on Combinatorial
Mathematics, Armidale, Australia}, 119--126
}
\seealso{
\code{\link[ape]{dist.topo}}, \code{\link{nni}},
\code{\link{superTree}}, \code{\link{mast}}
}
\author{
Klaus P. Schliep \email{klaus.schliep@gmail.com},
Leonardo de Oliveira Martins
}
\keyword{classif}
