% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{append_estimation_step_options}
\alias{append_estimation_step_options}
\title{append_estimation_step_options}
\usage{
append_estimation_step_options(model, options, idx)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{options}{(list) any additional tool specific options}

\item{idx}{(integer) index of estimation step}
}
\value{
(Model) Reference to the same model object
}
\description{
Append estimation step options

Appends options to an existing estimation step.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
opts <- list('NITER'=1000, 'ISAMPLE'=100, 'EONLY'=1)
append_estimation_step_options(model, options=opts, idx=0)
est <- model$estimation_steps[1]
len(est$options)
}
}
\seealso{
add_estimation_step

set_estimation_step

remove_estimation_step
}
