% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{set_zero_order_input}
\alias{set_zero_order_input}
\title{set_zero_order_input}
\usage{
set_zero_order_input(model, compartment, expression)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{compartment}{(str) Name of the compartment}

\item{expression}{(str or numeric) The expression of the zero order input}
}
\value{
(model) Pharmpy model object
}
\description{
Set a zero order input for the ode system

If the zero order input is already set it will be updated.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model <- set_zero_order_input(model, "CENTRAL", 10)
get_zero_order_inputs(model)
}

}
