% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{get_unit_of}
\alias{get_unit_of}
\title{get_unit_of}
\usage{
get_unit_of(model, variable)
}
\arguments{
\item{model}{(Model) Pharmpy model object}

\item{variable}{(str) Find physical unit of this variable}
}
\value{
(Unit) A unit expression
}
\description{
Derive the physical unit of a variable in the model

Unit information for the dataset needs to be available.
The variable can be defined in the code, a dataset olumn, a parameter
or a random variable.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
get_unit_of(model, "Y")
get_unit_of(model, "VC")
get_unit_of(model, "WGT")
}

}
