% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{predict_influential_outliers}
\alias{predict_influential_outliers}
\title{predict_influential_outliers}
\usage{
predict_influential_outliers(
  model,
  results,
  outlier_cutoff = 3,
  influential_cutoff = 3.84
)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{results}{(ModelfitResults) Results for model}

\item{outlier_cutoff}{(numeric) Cutoff threshold for a residual signaling an outlier}

\item{influential_cutoff}{(numeric) Cutoff threshold for a dofv signaling an influential individual}
}
\value{
(data.frame) Dataframe over the individuals with a \code{outliers} and \code{dofv} columns containing the raw predictions and \code{influential}, \code{outlier} and \code{influential_outlier} boolean columns.
}
\description{
Predict influential outliers for a model using a machine learning model.

Please refer to www.page-meeting.org/?abstract=10029 for more information on training and estimated
precision and accuracy.
}
\seealso{
predict_influential_individuals

predict_outliers
}
